/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobeMenu
extends AbstractContainerMenu {
    private final class_1657 player;
    private final SkinWardrobe wardrobe;
    private final ArrayList<class_1799> lastSyncSlot = new ArrayList();
    private final ArrayList<class_1735> customSlots = new ArrayList();
    private final int slotsX = 83;
    private final int slotsY = 27;
    private Group group = null;

    public SkinWardrobeMenu(class_3917<?> menuType, int containerId, class_1661 inventory, SkinWardrobe wardrobe) {
        super(menuType, containerId);
        this.wardrobe = wardrobe;
        this.player = inventory.field_7546;
        this.addPlayerSlots((class_1263)inventory, 59, 168, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addSkinSlots(SkinSlotType.HEAD, Group.SKINS, 0, 0);
        this.addSkinSlots(SkinSlotType.CHEST, Group.SKINS, 0, 1);
        this.addSkinSlots(SkinSlotType.LEGS, Group.SKINS, 0, 2);
        this.addSkinSlots(SkinSlotType.FEET, Group.SKINS, 0, 3);
        this.addSkinSlots(SkinSlotType.WINGS, Group.SKINS, 0, 4);
        this.addEquipmentSlots(Group.SKINS, 0, 5);
        this.addSkinSlots(SkinSlotType.OUTFIT, Group.OUTFITS, 0, 0);
        this.addSkinSlots(SkinSlotType.BACKPACK, Group.OUTFITS, 0, 5);
        this.addSkinSlots(SkinSlotType.HORSE, Group.UNKNOWN, 0, 0);
        this.addSkinSlots(SkinSlotType.DYE, Group.DYES, 0, 0);
        this.addMannequinSlots(Group.SKINS, 0, 5);
    }

    protected void addEquipmentSlots(Group group, int column, int row) {
        SkinSlotType[] slotTypes = new SkinSlotType[]{SkinSlotType.SWORD, SkinSlotType.SHIELD, SkinSlotType.BOW, SkinSlotType.TRIDENT, null, SkinSlotType.PICKAXE, SkinSlotType.AXE, SkinSlotType.SHOVEL, SkinSlotType.HOE};
        boolean hasContents = false;
        for (SkinSlotType slotType : slotTypes) {
            if (slotType != null) {
                int count = this.wardrobe.getUnlockedSize(slotType);
                if (count <= 0) continue;
                hasContents = true;
                this.addSkinSlots(slotType, group, column, row);
                column += count;
                continue;
            }
            if (!hasContents) continue;
            ++column;
        }
    }

    protected void addMannequinSlots(Group group, int column, int row) {
        class_1297 class_12972 = this.wardrobe.entity();
        if (class_12972 instanceof MannequinEntity) {
            MannequinEntity entity = (MannequinEntity)class_12972;
            class_1263 inventory = entity.getInventory();
            int size = inventory.method_5439();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                int x = 83 + (column + (size - i - 1)) * 19;
                int y = 27 + row * 19;
                SkinSlot slot = this.addGroupSlot(inventory, i, x, y, group, new SkinSlotType[0]);
                this.customSlots.add(slot);
            }
        }
    }

    protected void addSkinSlots(SkinSlotType slotType, Group group, int column, int row) {
        int index = slotType.index();
        int size = this.wardrobe.getUnlockedSize(slotType);
        class_1263 inventory = this.wardrobe.inventory();
        for (int i = 0; i < size; ++i) {
            int x = 83 + (column + i) * 19;
            int y = 27 + row * 19;
            SkinSlot slot = this.addGroupSlot(inventory, index + i, x, y, group, slotType);
            this.customSlots.add(slot);
        }
    }

    protected SkinSlot addGroupSlot(class_1263 inventory, int index, int x, int y, final Group group, SkinSlotType ... slotTypes) {
        SkinSlot slot = new SkinSlot(inventory, index, x, y, slotTypes){

            public boolean method_7682() {
                return SkinWardrobeMenu.this.group() == group;
            }

            @Override
            public boolean method_7680(class_1799 itemStack) {
                if (ModConfig.Common.onlySkinIntoSlots && !itemStack.method_31574((class_1792)ModItems.SKIN.get())) {
                    return false;
                }
                return super.method_7680(itemStack);
            }
        };
        this.method_7621(slot);
        return slot;
    }

    public List<class_1735> customSlots() {
        return this.customSlots;
    }

    public void forEachCustomSlots(Consumer<class_1735> consumer) {
        for (class_1735 slot : this.customSlots) {
            if (!slot.method_7682()) continue;
            consumer.accept(slot);
        }
    }

    public boolean method_7597(class_1657 player) {
        class_1297 entity = this.entity();
        if (entity == null || !entity.method_5805() || !this.wardrobe.isEditable(player)) {
            return false;
        }
        return entity.method_5649(player.method_23317(), player.method_23318(), player.method_23321()) <= 64.0;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = slot.method_7677();
        if (slot instanceof SkinSlot) {
            if (!this.method_7616(itemStack, 9, 36, false) && !this.method_7616(itemStack, 0, 9, false)) {
                return class_1799.field_8037;
            }
            slot.method_7673(class_1799.field_8037);
            return itemStack.method_7972();
        }
        SkinSlotType slotType = SkinSlotType.byItem(itemStack);
        if (slotType != null && this.wardrobe.isSupported(slotType)) {
            int startIndex = this.getFreeSlot(slotType);
            if (!this.method_7616(itemStack, startIndex, startIndex + 1, false)) {
                return class_1799.field_8037;
            }
            slot.method_7673(class_1799.field_8037);
            return itemStack.method_7972();
        }
        if (this.wardrobe.entity() instanceof MannequinEntity) {
            int startIndex = this.getFreeSlot(SkinSlotType.ANY);
            if (!this.method_7616(itemStack, startIndex, startIndex + 1, false)) {
                return class_1799.field_8037;
            }
            slot.method_7673(class_1799.field_8037);
            return itemStack.method_7972();
        }
        return class_1799.field_8037;
    }

    public void method_7623() {
        super.method_7623();
        if (PropertyProvider.getLevel((class_1297)this.player).method_8608()) {
            return;
        }
        if (this.lastSyncSlot.size() != this.field_7761.size()) {
            this.lastSyncSlot.ensureCapacity(this.field_7761.size());
            this.field_7761.forEach(s -> this.lastSyncSlot.add(s.method_7677()));
            return;
        }
        int changes = 0;
        for (int index = 0; index < this.field_7761.size(); ++index) {
            if (index < 36) continue;
            class_1799 newItemStack = ((class_1735)this.field_7761.get(index)).method_7677();
            if (this.lastSyncSlot.get(index).equals(newItemStack)) continue;
            this.lastSyncSlot.set(index, newItemStack);
            ++changes;
        }
        if (changes != 0) {
            ModLog.debug("observer slots has {} changes, sync to players", changes);
            this.wardrobe.broadcast();
        }
    }

    public boolean shouldRenderInventory() {
        return this.group != null && this.group.shouldRenderInventory();
    }

    private int getFreeSlot(SkinSlotType slotType) {
        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof SkinSlot)) continue;
            SkinSlot slot1 = (SkinSlot)slot;
            if (slot.method_7681() || !slot1.slotTypes().contains((Object)slotType) && !slot1.slotTypes().isEmpty()) continue;
            return slot1.field_7874;
        }
        return 0;
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public SkinWardrobe wardrobe() {
        return this.wardrobe;
    }

    @Nullable
    public class_1297 entity() {
        return this.wardrobe.entity();
    }

    public static enum Group {
        SKINS(true, 99),
        OUTFITS(true, 99),
        UNKNOWN(true, 99),
        DYES(true, 99),
        COLORS(false, 99);

        private final boolean exchanges;
        private final int extendedHeight;

        private Group(boolean exchanges, int extendedHeight) {
            this.exchanges = exchanges;
            this.extendedHeight = extendedHeight;
        }

        public boolean shouldRenderInventory() {
            return this.exchanges;
        }

        public int extendedHeight() {
            return this.extendedHeight;
        }
    }
}

