/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.cache;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.data.cache.AutoreleasePool;
import moe.plushie.armourers_workshop.core.utils.ReferenceCounted;

public class ObjectPool<T> {
    private final Supplier<T> creator;
    private final Deque<T> reusable;
    private final AutoreleasePool<Page> autoreleasePool = new AutoreleasePool<Page>(() -> new Page());

    protected ObjectPool(Supplier<T> creator, boolean isConcurrent) {
        this.creator = creator;
        this.reusable = isConcurrent ? new ConcurrentLinkedDeque<T>() : new ArrayDeque<T>();
    }

    public static <T> ObjectPool<T> create(Supplier<T> creator) {
        return ObjectPool.create(creator, false);
    }

    public static <T> ObjectPool<T> create(Supplier<T> creator, boolean isConcurrent) {
        return new ObjectPool<T>(creator, isConcurrent);
    }

    protected void recycle(List<T> objects, List<T> rollback) {
        int recycled = objects.size();
        int available = this.reusable.size();
        if (available > recycled * 2) {
            return;
        }
        for (T object : objects) {
            ReferenceCounted counted;
            if (object instanceof ReferenceCounted && (counted = (ReferenceCounted)object).refCnt() != 0) {
                rollback.add(object);
                continue;
            }
            this.reusable.add(object);
        }
    }

    public T get() {
        Page page = this.autoreleasePool.get();
        T value = this.reusable.poll();
        if (value == null) {
            value = this.creator.get();
        }
        page.track(value);
        return value;
    }

    protected class Page
    implements AutoreleasePool.Lifecycle {
        private List<T> releasing;
        private List<T> usedQueue = new ArrayList();
        private List<T> rollbackQueue = new ArrayList();

        protected Page() {
        }

        @Override
        public void begin() {
            this.releasing = this.usedQueue;
        }

        @Override
        public void end() {
            this.releasing = null;
            if (this.usedQueue.isEmpty()) {
                return;
            }
            List oldQueue = this.usedQueue;
            ObjectPool.this.recycle(oldQueue, this.rollbackQueue);
            oldQueue.clear();
            this.usedQueue = this.rollbackQueue;
            this.rollbackQueue = oldQueue;
        }

        public void track(T value) {
            if (this.releasing != null) {
                this.releasing.add(value);
            }
        }
    }
}

