/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractCapabilityStorage;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CapabilityStorage {
    private static final ArrayList<Entry<?>> ENTRIES = new ArrayList();
    private static final CapabilityStorage NONE = new CapabilityStorage(new IdentityHashMap());
    private final IdentityHashMap<IEntityCapability<?>, Pair<Entry<?>, Optional<?>>> capabilities;

    CapabilityStorage(IdentityHashMap<IEntityCapability<?>, Pair<Entry<?>, Optional<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    public static <T> void registerCapability(IResourceLocation registryName, IEntityCapability<T> capabilityType, Function<class_1297, Optional<T>> provider) {
        ENTRIES.add(new Entry<T>(registryName, capabilityType, provider));
    }

    public static CapabilityStorage attachCapability(class_1297 entity) {
        if (ENTRIES.isEmpty()) {
            return NONE;
        }
        IdentityHashMap capabilities = new IdentityHashMap();
        for (Entry<?> entry : ENTRIES) {
            Optional cap = entry.provider.apply(entity);
            if (!cap.isPresent()) continue;
            capabilities.put(entry.capabilityType, Pair.of(entry, cap));
        }
        if (capabilities.isEmpty()) {
            return NONE;
        }
        return new CapabilityStorage(capabilities);
    }

    public static <T> Optional<T> getCapability(class_1297 entity, IEntityCapability<T> capabilityType) {
        CapabilityStorage storage = ((Provider)entity).getCapabilityStorage();
        Pair<Entry<?>, Optional<?>> value = storage.capabilities.get(capabilityType);
        if (value != null) {
            return (Optional)Objects.unsafeCast((Optional)value.getValue());
        }
        return Optional.empty();
    }

    public void save(class_1297 entity, class_2487 tag) {
        if (this == NONE) {
            return;
        }
        String capsKey = AbstractCapabilityStorage.KEY;
        class_2487 caps = OptionalAPI.getOptionalCompound(tag, capsKey).orElseGet(class_2487::new);
        this.capabilities.values().forEach(pair -> {
            Object patt0$temp = ((Optional)pair.getValue()).orElse(null);
            if (patt0$temp instanceof IDataSerializable.Mutable) {
                IDataSerializable.Mutable provider = patt0$temp;
                class_2487 tag1 = new class_2487();
                provider.serialize(SkinWardrobeStorage.encoder(entity, tag1));
                caps.method_10566(((Entry)pair.getKey()).registryName.toString(), (class_2520)tag1);
            }
        });
        if (!caps.method_33133()) {
            tag.method_10566(capsKey, (class_2520)caps);
        } else {
            tag.method_10551(capsKey);
        }
    }

    public void load(class_1297 entity, class_2487 tag) {
        if (this == NONE) {
            return;
        }
        class_2487 caps = this.getCapTag(tag);
        if (caps == null || caps.method_33133()) {
            return;
        }
        this.capabilities.values().forEach(pair -> {
            Object patt0$temp = ((Optional)pair.getValue()).orElse(null);
            if (patt0$temp instanceof IDataSerializable.Mutable) {
                IDataSerializable.Mutable provider = patt0$temp;
                class_2520 containerTag = caps.method_10580(((Entry)pair.getKey()).registryName.toString());
                if (containerTag instanceof class_2487) {
                    class_2487 compoundTag = (class_2487)containerTag;
                    provider.deserialize(SkinWardrobeStorage.decoder(entity, compoundTag));
                }
            }
        });
    }

    @Nullable
    private class_2487 getCapTag(class_2487 tag) {
        Optional<class_2487> newValue = OptionalAPI.getOptionalCompound(tag, "neoforge:attachments");
        class_2487 oldValue = OptionalAPI.getOptionalCompound(tag, "ForgeCaps").orElse(null);
        if (oldValue != null) {
            return newValue.map(newCaps -> oldValue.method_10553().method_10543(newCaps)).orElse(oldValue);
        }
        return newValue.orElse(null);
    }

    private static class Entry<T> {
        IResourceLocation registryName;
        IEntityCapability<T> capabilityType;
        Function<class_1297, Optional<T>> provider;

        Entry(IResourceLocation registryName, IEntityCapability<T> capabilityType, Function<class_1297, Optional<T>> provider) {
            this.registryName = registryName;
            this.capabilityType = capabilityType;
            this.provider = provider;
        }
    }

    public static interface Provider {
        public CapabilityStorage getCapabilityStorage();
    }
}

