/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.compatibility.client.AbstractCustomProfileTextureLoader;
import moe.plushie.armourers_workshop.compatibility.core.AbstractCustomProfileLoader;
import moe.plushie.armourers_workshop.core.client.other.SkinRemoteTexture;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTexture;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenNativeImage;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TextureUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntityTextureLoader {
    public static final OpenResourceLocation STEVE_SKIN_LOCATION = OpenResourceLocation.parse("textures/entity/steve.png");
    public static final OpenResourceLocation ALEX_SKIN_LOCATION = OpenResourceLocation.parse("textures/entity/alex.png");
    private static final UUID NIL_UUID = new UUID(0L, 0L);
    private static final EntityTextureLoader LOADER = new EntityTextureLoader();
    private final TaskQueue<String, GameProfile> namedProfiles = new TaskQueue(this::loadGameProfile);
    private final TaskQueue<EntityTextureDescriptor, EntityTexture> namedTextures = new TaskQueue(this::loadTexture);
    private final TaskQueue<OpenResourceLocation, BakedEntityTexture> registeredModels = new TaskQueue(this::loadTexture);
    private final HashMap<String, BakedEntityTexture> downloadedModels = new HashMap();
    private final Executor workThread = Executors.newFixedThreadPool(1, "AW-SKIN/T-LD");

    public static EntityTextureLoader getInstance() {
        return LOADER;
    }

    public void start() {
    }

    public void stop() {
        this.namedProfiles.clear();
        this.namedTextures.clear();
        this.registeredModels.clear();
    }

    public GameProfile getGameProfile(EntityTextureDescriptor descriptor) {
        GameProfile profile = descriptor.profile();
        if (profile != null) {
            return profile;
        }
        String name = descriptor.name();
        if (name != null) {
            return this.namedProfiles.getOrCreate(descriptor.name()).get();
        }
        return null;
    }

    @Nullable
    public BakedEntityTexture getTextureModel(OpenResourceLocation location) {
        if (location == null) {
            return null;
        }
        return this.registeredModels.getOrCreate(location).get();
    }

    public OpenResourceLocation getTextureLocation(class_1297 entity) {
        MannequinEntity mannequin;
        EntityTextureDescriptor descriptor;
        EntityTexture texture;
        if (entity instanceof MannequinEntity && (texture = this.loadTexture(descriptor = (mannequin = (MannequinEntity)entity).getTextureDescriptor())) != null && texture.location() != null) {
            return texture.location();
        }
        return TextureUtils.getTexture(entity);
    }

    public OpenResourceLocation getTextureLocation(EntityTextureDescriptor descriptor) {
        EntityTexture texture1;
        if (!descriptor.isEmpty() && (texture1 = this.loadTexture(descriptor)) != null) {
            return texture1.location();
        }
        return ModTextures.MANNEQUIN_DEFAULT;
    }

    @Nullable
    public EntityTexture loadTexture(EntityTextureDescriptor descriptor) {
        if (descriptor.isEmpty()) {
            return null;
        }
        return this.namedTextures.getOrCreate(descriptor).get();
    }

    public void loadGameProfile(String name, IResultHandler<GameProfile> handler) {
        this.namedProfiles.getOrCreate(name).listen(handler);
    }

    private void loadGameProfile(String name, Task<GameProfile> task) {
        this.workThread.execute(() -> {
            GameProfile profile = new GameProfile(NIL_UUID, name);
            AbstractCustomProfileLoader.load(profile, task);
        });
    }

    public void loadTexture(EntityTextureDescriptor descriptor, IResultHandler<EntityTexture> handler) {
        this.namedTextures.getOrCreate(descriptor).listen(handler);
    }

    private void loadTexture(EntityTextureDescriptor descriptor, Task<EntityTexture> task) {
        if (descriptor.isEmpty()) {
            task.accept(EntityTexture.EMPTY);
            return;
        }
        String url = descriptor.url();
        if (url != null) {
            try {
                URL ignored = new URL(url);
                this.loadTextureWithURL(url, task);
            }
            catch (MalformedURLException e) {
                task.abort(new RuntimeException("Invalid URL: " + url));
            }
            return;
        }
        GameProfile profile = descriptor.profile();
        if (profile != null) {
            this.loadTextureWithProfile(profile, task);
            return;
        }
        String name = descriptor.name();
        if (name != null) {
            this.loadTextureWithName(name, task);
            return;
        }
        task.abort(new RuntimeException("Invalid Descriptor: " + String.valueOf(descriptor)));
    }

    private void loadTextureWithName(String name, Task<EntityTexture> task) {
        this.loadGameProfile(name, (GameProfile profile, Exception exception) -> {
            if (profile != null) {
                this.loadTextureWithProfile((GameProfile)profile, task);
            } else {
                exception.printStackTrace();
                task.abort(new RuntimeException("Invalid User: " + name));
            }
        });
    }

    private void loadTextureWithProfile(GameProfile profile, Task<EntityTexture> task) {
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.fromProfile(profile);
        Task<EntityTexture> owner = this.namedTextures.getOrCreate(descriptor);
        if (owner != task) {
            owner.listen(task);
            return;
        }
        ModLog.debug("load entity texture: {}", profile);
        AbstractCustomProfileTextureLoader.load(profile, (location, url, modelType) -> {
            ModLog.debug("accept entity texture from vanilla loader: {}, {}", location, profile);
            task.accept(this.buildEntityTexture(descriptor, location, url, modelType));
        });
    }

    private void loadTextureWithURL(String url, Task<EntityTexture> task) {
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.fromURL(url);
        Task<EntityTexture> owner = this.namedTextures.getOrCreate(descriptor);
        if (owner != task) {
            owner.listen(task);
            return;
        }
        ModLog.debug("load entity texture: {}", url);
        String identifier = Objects.md5(url);
        OpenResourceLocation location = OpenResourceLocation.parse("skins/aw-" + identifier);
        class_1060 textureManager = class_310.method_1551().method_1531();
        String prefix = identifier.substring(0, 2);
        File path = new File(String.valueOf(EnvironmentManager.getRootDirectory()) + "/skin-textures/" + prefix + "/" + identifier);
        SkinRemoteTexture downloadingTexture = new SkinRemoteTexture(url, path, ModTextures.MANNEQUIN_DEFAULT, true, () -> {
            ModLog.debug("accept entity texture from custom loader => {}", location);
            task.accept(this.buildEntityTexture(descriptor, location, url, null));
        });
        textureManager.method_4616(location.toLocation(), (class_1044)downloadingTexture);
    }

    private void loadTexture(OpenResourceLocation location, Task<BakedEntityTexture> task) {
        boolean steve = location.equals(STEVE_SKIN_LOCATION);
        boolean alex = location.equals(ALEX_SKIN_LOCATION);
        if (!steve && !alex) {
            return;
        }
        this.workThread.execute(() -> {
            BakedEntityTexture texture = new BakedEntityTexture(location, alex);
            task.accept(texture);
        });
    }

    public void receivePlayerTexture(String url, OpenNativeImage image, boolean slim) {
        if (image == null) {
            return;
        }
        OpenNativeImage newImage = image.clone();
        this.workThread.execute(() -> {
            BakedEntityTexture bakedTexture = this.getDownloadedTexture(url);
            if (bakedTexture.modelType() == null) {
                bakedTexture.setModelType("default");
                if (slim) {
                    bakedTexture.setModelType("slim");
                }
            }
            bakedTexture.loadImage(newImage, Objects.equals(bakedTexture.modelType(), "slim"));
            ModLog.debug("baked a player texture => {}, url: {}, slim: {}", bakedTexture.location(), url, slim);
        });
    }

    private synchronized BakedEntityTexture getDownloadedTexture(String url) {
        return this.downloadedModels.computeIfAbsent(url, k -> new BakedEntityTexture());
    }

    private synchronized EntityTexture buildEntityTexture(EntityTextureDescriptor descriptor, OpenResourceLocation location, String url, String modelType) {
        EntityTexture texture = new EntityTexture(descriptor, location, url, modelType);
        BakedEntityTexture model = this.getDownloadedTexture(url);
        model.setResourceLocation(location);
        model.setModelType(modelType);
        texture.setTexture(model);
        this.registeredModels.getOrCreate(location).accept(model);
        return texture;
    }

    private static class TaskQueue<K, V> {
        private final BiConsumer<K, Task<V>> handler;
        private final ConcurrentHashMap<K, Task<V>> values = new ConcurrentHashMap();

        public TaskQueue(BiConsumer<K, Task<V>> handler) {
            this.handler = handler;
        }

        public void clear() {
            this.values.clear();
        }

        public Task<V> getOrCreate(K key) {
            Task<V> task = this.values.get(key);
            if (task != null) {
                return task;
            }
            task = new Task();
            this.values.put(key, task);
            this.handler.accept(key, task);
            return task;
        }
    }

    private static class Task<V>
    implements IResultHandler<V> {
        private V value;
        private Exception exception;
        private boolean isCompleted = false;
        private ConcurrentLinkedDeque<IResultHandler<V>> handlers = new ConcurrentLinkedDeque();

        private Task() {
        }

        @Override
        public void apply(V value, Exception exception) {
            this.value = value;
            this.exception = exception;
            this.isCompleted = true;
            this.invoke();
        }

        public void invoke() {
            if (this.handlers.isEmpty()) {
                return;
            }
            ConcurrentLinkedDeque<IResultHandler<V>> handlers = this.handlers;
            this.handlers = new ConcurrentLinkedDeque();
            handlers.forEach((Consumer<IResultHandler<V>>)((Consumer<IResultHandler>)handler -> handler.apply(this.value, this.exception)));
        }

        public void listen(@Nullable IResultHandler<V> handler) {
            if (this.isCompleted) {
                if (handler != null) {
                    handler.apply(this.value, this.exception);
                }
                return;
            }
            if (handler != null) {
                this.handlers.add(handler);
            }
        }

        public V get() {
            return this.value;
        }
    }
}

