/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.ModelView;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRendererContext;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_897;

public class FallbackEntityRenderPatch<T extends class_1297>
extends EntityRenderPatch<T> {
    private static final float SCALE = 0.0625f;
    private final BakedArmature armature;

    public FallbackEntityRenderPatch(BakedArmatureTransformer transformer, EntityRenderData renderData, EntityRendererContext context) {
        super(renderData, context);
        this.transformer = transformer;
        this.armature = BakedArmature.mutableBy(transformer.armature());
    }

    public static <T extends class_1297> void activate(T entity, float partialTicks, int packedLight, class_4587 poseStackIn, class_897<?> entityRenderer, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._activate(FallbackEntityRenderPatch.class, entity, partialTicks, packedLight, poseStackIn, entityRenderer, handler, (renderData, rendererStorage) -> {
            BakedArmatureTransformer transformer = rendererStorage.getTransformer(null);
            if (transformer != null) {
                return new FallbackEntityRenderPatch(transformer, renderData, rendererStorage);
            }
            return null;
        });
    }

    public static <T extends class_1297> void apply(T entity, class_4587 poseStackIn, class_4597 buffersIn, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._apply(FallbackEntityRenderPatch.class, entity, poseStackIn, buffersIn, handler);
    }

    public static <T extends class_1297> void deactivate(T entity, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._deactivate(FallbackEntityRenderPatch.class, entity, handler);
    }

    @Override
    protected void onApply(class_1297 entity, class_4587 poseStackIn, class_4597 bufferSourceIn) {
        IPoseStack poseStack = this.pluginContext.poseStack();
        EntityRenderData renderData = this.pluginContext.renderData();
        poseStack.pushPose();
        this.transformer.activate(entity, this.pluginContext);
        this.transformer.applyTo(this.armature);
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        this.renderingContext.setOverlay(this.pluginContext.overlay());
        this.renderingContext.setLightmap(this.pluginContext.lightmap());
        this.renderingContext.setPartialTicks(this.pluginContext.partialTicks());
        this.renderingContext.setAnimationTicks(this.pluginContext.animationTicks());
        this.renderingContext.setPoseStack(this.pluginContext.poseStack());
        this.renderingContext.setBufferSource(AbstractBufferSource.wrap(bufferSourceIn));
        this.renderingContext.setModelViewStack(AbstractPoseStack.create(ModelView.getExtendedModelViewStack(RenderSystem.class)));
        for (EntitySlot entry : renderData.itemSkins()) {
            this.renderingContext.setOverlay(entry.getOverrideOverlay(entity));
            this.renderingContext.setItemSource(SkinItemSource.create(entry.renderPriority(), entry.itemStack()));
            BakedSkin bakedSkin = entry.skin();
            bakedSkin.setupAnim(entity, this.armature, this.renderingContext);
            SkinPaintScheme paintScheme = bakedSkin.resolve(entity, entry.paintScheme());
            SkinRenderer.render(entity, this.armature, bakedSkin, paintScheme, this.renderingContext);
        }
        poseStack.popPose();
    }
}

