/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinItemProperties;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class EmbeddedItemModel {
    private SkinItemProperties properties;
    private final class_1309 entity;
    private final class_1937 level;
    private final int sourceMode;
    private final class_1799 sourceStack;
    private final SkinDescriptor sourceSkin;
    private final EntitySlot sourceSlot;

    private EmbeddedItemModel(@Nullable class_1309 entity, @Nullable class_1937 level, int sourceMode, EntitySlot sourceSlot, SkinDescriptor sourceSkin, class_1799 sourceStack) {
        this.entity = entity;
        this.level = level;
        this.sourceMode = sourceMode;
        this.sourceStack = sourceStack;
        this.sourceSkin = sourceSkin;
        this.sourceSlot = sourceSlot;
    }

    public static EmbeddedItemModel fromWardrobe(@Nullable class_1309 entity, @Nullable class_1937 level, EntitySlot slot) {
        return new EmbeddedItemModel(entity, level, 0, slot, slot.descriptor(), slot.itemStack());
    }

    public static EmbeddedItemModel fromComponent(@Nullable class_1309 entity, @Nullable class_1937 level, SkinDescriptor descriptor, class_1799 itemStack) {
        return new EmbeddedItemModel(entity, level, 1, null, descriptor, itemStack);
    }

    public static EmbeddedItemModel fromSelf(@Nullable class_1309 entity, @Nullable class_1937 level, SkinDescriptor descriptor, class_1799 itemStack) {
        return new EmbeddedItemModel(entity, level, 2, null, descriptor, itemStack);
    }

    public class_1309 entity() {
        return this.entity;
    }

    public class_1937 level() {
        return this.level;
    }

    public void setProperties(SkinItemProperties properties) {
        this.properties = properties;
    }

    public SkinItemProperties properties() {
        return this.properties;
    }

    public SkinDescriptor sourceSkin() {
        return this.sourceSkin;
    }

    public class_1799 sourceStack() {
        return this.sourceStack;
    }

    public EntitySlot sourceSlot() {
        return this.sourceSlot;
    }

    public boolean shouldRenderInBox() {
        if (this.sourceMode == 2) {
            return true;
        }
        SkinType skinType = this.sourceSkin.type();
        if (skinType == SkinTypes.BOAT || skinType == SkinTypes.ITEM_FISHING || skinType == SkinTypes.HORSE) {
            return true;
        }
        if (skinType.isTool()) {
            return false;
        }
        return skinType != SkinTypes.ITEM;
    }
}

