/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import moe.plushie.armourers_workshop.core.client.render.MannequinEntityRenderer;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;

@Environment(value=EnvType.CLIENT)
public class EntityPreviewView
extends UIControl {
    private CGPoint lastMousePos;
    private OpenVector3f lastPlayerRotation = new OpenVector3f(-20.0f, 45.0f, 0.0f);

    public EntityPreviewView(CGRect frame) {
        super(frame);
        this.setClipBounds(true);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        Object object = this.contents();
        if (!(object instanceof class_1297)) {
            return;
        }
        class_1297 entity = (class_1297)object;
        CGRect bounds = this.bounds();
        RenderSystem.setExtendedScissorFlags(1);
        MannequinEntityRenderer.enableLimitScale = true;
        MannequinEntityRenderer.enableLimitYRot = true;
        context.saveGraphicsState();
        context.translateCTM(0.0f, 0.0f, 300.0f);
        context.translateCTM(bounds.midX(), bounds.maxY() - 8.0f, 50.0f);
        context.rotateCTM(this.lastPlayerRotation.x(), 0.0f, 0.0f);
        context.rotateCTM(0.0f, this.lastPlayerRotation.y(), 0.0f);
        context.translateCTM(0.0f, 0.0f, -50.0f);
        context.drawEntity(entity, CGPoint.ZERO, 45, CGPoint.ZERO);
        context.restoreGraphicsState();
        MannequinEntityRenderer.enableLimitYRot = false;
        MannequinEntityRenderer.enableLimitScale = false;
        RenderSystem.setExtendedScissorFlags(0);
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.setClipBounds(!highlighted);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        this.lastMousePos = null;
        if (event.type() == UIEvent.Type.MOUSE_RIGHT_DOWN) {
            this.lastMousePos = event.locationInWindow();
        }
    }

    @Override
    public void mouseDragged(UIEvent event) {
        super.mouseDragged(event);
        CGPoint oldMousePos = this.lastMousePos;
        if (oldMousePos == null) {
            return;
        }
        float yRot = this.lastPlayerRotation.y();
        this.lastMousePos = event.locationInWindow();
        this.lastPlayerRotation.setY((yRot + (this.lastMousePos.x - oldMousePos.x) + 360.0f) % 360.0f);
    }
}

