/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.core.client.gui.widget.BaseDialog;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConfirmDialog
extends BaseDialog {
    protected final UILabel messageLabel = new UILabel(new CGRect(0.0f, 8.0f, 240.0f, 20.0f));
    protected final UIButton confirmButton = this.buildButton(0, 0, 100, 20, ConfirmDialog::confirmAction);
    protected final UIButton cancelButton = this.buildButton(0, 0, 100, 20, ConfirmDialog::cancelAction);
    private int selectedIndex = 0;
    private NSString cancelText;
    private NSString confirmText;

    public ConfirmDialog() {
        this.messageLabel.setNumberOfLines(0);
        this.addSubview(this.messageLabel);
        this.setConfirmText(NSString.localizedString("common.button.ok", new Object[0]));
        this.setCancelText(NSString.localizedString("common.button.cancel", new Object[0]));
        this.setup();
    }

    private void setup() {
        CGRect rect = this.bounds();
        float w = this.buttonWidth();
        float sp = (rect.width - w * 2.0f) / 3.0f;
        float bottom = rect.height - 30.0f;
        this.messageLabel.setFrame(new CGRect(10.0f, 30.0f, rect.width - 20.0f, 20.0f));
        this.messageLabel.setAutoresizingMask(2);
        this.confirmButton.setFrame(new CGRect(sp, bottom, w, 20.0f));
        this.confirmButton.setAutoresizingMask(12);
        this.cancelButton.setFrame(new CGRect(rect.width - w - sp, bottom, w, 20.0f));
        this.cancelButton.setAutoresizingMask(9);
    }

    public NSString message() {
        return this.messageLabel.text();
    }

    public void setMessage(NSString message) {
        this.messageLabel.setText(message);
    }

    public UIColor messageColor() {
        return this.messageLabel.textColor();
    }

    public void setMessageColor(UIColor color) {
        this.messageLabel.setTextColor(color);
    }

    public NSString confirmText() {
        return this.confirmText;
    }

    public void setConfirmText(NSString text) {
        this.confirmText = text;
        this.confirmButton.setTitle(text, 0);
    }

    public NSString cancelText() {
        return this.cancelText;
    }

    public void setCancelText(NSString text) {
        this.cancelText = text;
        this.cancelButton.setTitle(text, 0);
    }

    public void confirmAction(UIControl sender) {
        this.selectedIndex = 1;
        this.dismiss();
    }

    public void cancelAction(UIControl sender) {
        this.selectedIndex = 0;
        this.dismiss();
    }

    public boolean isCancelled() {
        return this.selectedIndex == 0;
    }

    protected int buttonWidth() {
        return 100;
    }

    protected UIButton buildButton(int x, int y, int width, int height, BiConsumer<ConfirmDialog, UIControl> event) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitleColor(UIColor.WHITE, 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, event);
        this.addSubview(button);
        return button;
    }
}

