/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.FindableSkinManager;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;

@Environment(value=EnvType.CLIENT)
public class SkinPreloadManager {
    private static Object lastInventoryVersion = null;

    public static void start() {
        lastInventoryVersion = null;
        FindableSkinManager.getInstance().start();
    }

    public static void stop() {
        FindableSkinManager.getInstance().stop();
    }

    public static void tick(boolean isPaused) {
        class_1657 player;
        if (isPaused) {
            return;
        }
        if (lastInventoryVersion == null && (player = EnvironmentManager.getPlayer()) != null) {
            class_1661 inventory = player.method_31548();
            int inventoryVersion = inventory.method_7364();
            SkinPreloadManager.preloadInventory(inventory);
            lastInventoryVersion = inventoryVersion;
        }
        SkinPreloadManager.preloadConfig();
    }

    private static void preloadConfig() {
    }

    private static void preloadInventory(class_1661 inventory) {
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            SkinDescriptor descriptor = SkinDescriptor.of(inventory.method_5438(i));
            if (descriptor.isEmpty()) continue;
            ModLog.debug("'{}' => start preload skin", descriptor.identifier());
            SkinBakery.getInstance().loadSkin(descriptor, Tickets.PRELOAD);
        }
    }
}

