/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiFunction;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryQuads;
import moe.plushie.armourers_workshop.core.client.bake.BakedLuminanceCalculator;
import moe.plushie.armourers_workshop.core.client.bake.BakedRenderInfo;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferSource;
import moe.plushie.armourers_workshop.core.data.DataTransformer;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SkinBakery
implements ISkinLibraryListener {
    private static final SkinBakery EMPTY = new SkinBakery();
    private static SkinBakery BAKERY;
    private final ArrayList<IBakeListener> listeners = new ArrayList();
    private final DataTransformer<String, BakedSkin, Skin> manager = new DataTransformer.Builder().thread("AW-SKIN-BK", 1).loadCount(ModConfig.Client.modelBakingThreadCount).transformCount(ModConfig.Client.modelBakingThreadCount).loader(this::loadSkin0).transformer(this::bakeSkin0).build();

    public static SkinBakery getInstance() {
        if (BAKERY != null) {
            return BAKERY;
        }
        return EMPTY;
    }

    public static void start() {
        if (BAKERY == null) {
            BAKERY = new SkinBakery();
            BAKERY.startListenLibraryChanges();
            ModLog.debug("start bakery", new Object[0]);
        }
    }

    public static void stop() {
        if (BAKERY != null) {
            BAKERY.stopListenLibraryChanges();
            SkinBakery.BAKERY.manager.shutdown();
            BAKERY = null;
            SkinVertexBufferSource.clearAllCache();
            ModLog.debug("stop bakery", new Object[0]);
        }
    }

    public static void clear() {
        if (BAKERY != null) {
            SkinBakery.BAKERY.manager.clear();
            SkinVertexBufferSource.clearAllCache();
        }
    }

    public void addListener(IBakeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBakeListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public BakedSkin getSkin(String identifier) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.get(identifier);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(String identifier, Ticket ticket) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.getOrLoad(identifier, ticket);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(SkinDescriptor descriptor, Ticket ticket) {
        if (!descriptor.isEmpty()) {
            return this.loadSkin(descriptor.identifier(), ticket);
        }
        return null;
    }

    public void loadSkin(String identifier, Ticket ticket, IResultHandler<BakedSkin> handler) {
        this.manager.load(identifier, ticket, handler);
    }

    private void startListenLibraryChanges() {
        SkinLibraryManager.getClient().addListener(this);
    }

    private void stopListenLibraryChanges() {
        SkinLibraryManager.getClient().removeListener(this);
    }

    @Override
    public void libraryDidChanges(ISkinLibrary library, ISkinLibrary.Difference difference) {
        RenderSystem.recordRenderCall(() -> {
            difference.removedChanges().forEach(it -> this.invalidateSkin0(it.skinIdentifier()));
            difference.updatedChanges().forEach(it -> this.invalidateSkin0(((ISkinLibrary.Entry)it.getKey()).skinIdentifier()));
        });
    }

    private void invalidateSkin0(String identifier) {
        SkinLoader.getInstance().removeSkin(identifier);
        this.manager.remove(identifier);
    }

    private void loadSkin0(String identifier, IResultHandler<Skin> complete) {
        SkinLoader.getInstance().loadSkin(identifier, complete);
    }

    private void bakeSkin0(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        try {
            this.bakeSkin(identifier, skin, complete);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            complete.abort(exception);
        }
    }

    private void bakeSkin(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        ModLog.debug("'{}' => start baking skin", identifier);
        long startTime = System.currentTimeMillis();
        SkinUsedCounter usedCounter = new SkinUsedCounter();
        ArrayList<BakedSkinPart> rootParts = new ArrayList<BakedSkinPart>();
        ArrayList<BakedSkinPart> bakedParts = new ArrayList<BakedSkinPart>();
        SkinPaintScheme scheme = new SkinPaintScheme();
        ColorDescriptor colorInfo = new ColorDescriptor();
        BakedRenderInfo renderInfo = new BakedRenderInfo();
        this.eachPart(skin.parts(), null, (parent, part) -> {
            ArrayList children = new ArrayList();
            BakedGeometryQuads.from(part).forEach((partType, partTransform, quads) -> {
                SkinPart usedPart = part;
                if (usedPart.type() != partType) {
                    usedPart = new SkinPart.Builder((SkinPartType)partType).build();
                }
                BakedSkinPart bakedPart = new BakedSkinPart(usedPart, new SkinPartTransform(usedPart, partTransform), quads);
                children.add(bakedPart);
                bakedParts.add(bakedPart);
                usedCounter.add(quads.usedCounter());
            });
            BakedSkinPart mainChildPart = null;
            for (BakedSkinPart bakedPart : children) {
                if (parent != null) {
                    parent.addPart(bakedPart);
                } else {
                    rootParts.add(bakedPart);
                }
                if (bakedPart.part() != part) continue;
                mainChildPart = bakedPart;
            }
            return mainChildPart;
        });
        BakedGeometryQuads.from(skin.paintData()).forEach((partType, partTransform, quads) -> {
            SkinPart part = new SkinPart.Builder((SkinPartType)partType).build();
            BakedSkinPart bakedPart = new BakedSkinPart(part, new SkinPartTransform(part, partTransform), quads);
            bakedPart.setRenderPolygonOffset(20.0f);
            bakedParts.add(bakedPart);
            rootParts.add(bakedPart);
            usedCounter.add(quads.usedCounter());
            usedCounter.addMarkerTotal(bakedPart.markerTotal());
        });
        if (skin.settings().isPreviewMode()) {
            BakedGeometryQuads.from(skin.previewData()).forEach((partType, partTransform, quads) -> {
                SkinPart part = new SkinPart.Builder((SkinPartType)partType).build();
                BakedSkinPart bakedPart = new BakedSkinPart(part, new SkinPartTransform(part, partTransform), quads);
                bakedPart.setRenderPolygonOffset(bakedParts.size());
                bakedParts.add(bakedPart);
                rootParts.add(bakedPart);
                usedCounter.add(quads.usedCounter());
                usedCounter.addMarkerTotal(bakedPart.markerTotal());
            });
        }
        Collections.eachTree(bakedParts, BakedSkinPart::children, bakedPart -> {
            colorInfo.add(bakedPart.colorInfo());
            bakedPart.quads().forEach((renderType, it) -> renderInfo.add((IRenderType)renderType));
        });
        if (renderInfo.hasEmissive() && ModConfig.enableDynamicLightHandler()) {
            renderInfo.setLuminance(BakedLuminanceCalculator.apply(bakedParts));
        }
        usedCounter.addPaintType(colorInfo.paintTypes());
        long totalTime = System.currentTimeMillis() - startTime;
        BakedSkin bakedSkin = new BakedSkin(identifier, skin.type(), rootParts, skin, scheme, colorInfo, renderInfo, usedCounter);
        ModLog.debug("'{}' => accept baked skin, time: {}ms", identifier, totalTime);
        complete.accept(bakedSkin);
        RenderSystem.recordRenderCall(() -> this.notifyBake(identifier, bakedSkin));
        if (totalTime < 250L) {
            Executors.sleep(100L);
        }
    }

    private void notifyBake(String identifier, BakedSkin bakedSkin) {
        this.listeners.forEach(listener -> listener.didBake(identifier, bakedSkin));
    }

    private void eachPart(Collection<SkinPart> parts, BakedSkinPart parent, BiFunction<BakedSkinPart, SkinPart, BakedSkinPart> consumer) {
        for (SkinPart part : parts) {
            BakedSkinPart value = consumer.apply(parent, part);
            this.eachPart(part.children(), value, consumer);
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface IBakeListener {
        public void didBake(String var1, BakedSkin var2);
    }
}

