/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.core.block.AbstractAttachedHorizontalBlock;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlock
extends AbstractAttachedHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockHandler {
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2754<class_2742> PART = class_2741.field_12483;
    public static final class_2746 OCCUPIED = class_2741.field_12528;

    public SkinnableBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)FACE, (Comparable)class_2738.field_12471)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)class_2742.field_12560)).method_11657((class_2769)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_2586 createBlockEntity(class_1922 level, class_2338 blockPos, class_2680 blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).create(level, blockPos, blockState);
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 entity, class_1799 itemStack) {
        SkinBlockPlaceContext context = SkinBlockPlaceContext.of(blockPos);
        if (context == null) {
            return;
        }
        context.parts().forEach(part -> {
            class_2338 target = blockPos.method_10081((class_2382)part.offset());
            level.method_8652(target, blockState, 11);
            SkinnableBlockEntity blockEntity = this.getBlockEntity((class_1922)level, target);
            if (blockEntity != null) {
                TagSerializer serializer = new TagSerializer(new class_2487(), level);
                part.serialize(serializer);
                blockEntity.readAdditionalData(serializer);
                blockEntity.updateBlockStates();
            }
        });
        super.method_9567(level, blockPos, blockState, entity, itemStack);
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState.method_27852(blockState2.method_26204())) {
            this.brokenByAnything(level, blockPos, blockState, null);
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public List<class_1799> getDrops(class_2680 blockState, ILootContext context) {
        SkinnableBlockEntity blockEntity1;
        List<class_1799> results;
        block4: {
            block3: {
                results = super.getDrops(blockState, context);
                class_2586 blockEntity = context.getOptionalParameter(ILootContextParam.BLOCK_ENTITY);
                if (!(blockEntity instanceof SkinnableBlockEntity)) break block3;
                blockEntity1 = (SkinnableBlockEntity)blockEntity;
                if (!results.isEmpty()) break block4;
            }
            return results;
        }
        ArrayList<class_1799> fixedResults = new ArrayList<class_1799>(results.size());
        for (class_1799 itemStack : results) {
            if (itemStack.method_31574((class_1792)ModItems.SKIN.get()) && SkinDescriptor.of(itemStack).isEmpty() && (itemStack = blockEntity1.getDropped()) == null) continue;
            fixedResults.add(itemStack);
        }
        return fixedResults;
    }

    @Override
    public class_2680 destroyByPlayer(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1657 player) {
        this.brokenByAnything(level, blockPos, blockState, player);
        return super.destroyByPlayer(level, blockPos, blockState, player);
    }

    @Override
    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((class_1922)level, blockPos);
        if (blockEntity == null) {
            return class_1269.field_5814;
        }
        if (blockEntity.isLinked()) {
            Optional<class_1269> result = blockEntity.getLinkedValueFromParent((level1, pos) -> {
                class_2680 state = level1.method_8320(pos);
                return super.method_55766(state, (class_1937)level1, (class_2338)pos, player, blockHitResult);
            });
            return result.orElse(class_1269.field_5814);
        }
        if (blockEntity.isBed() && !player.method_21823() && ModPermissions.SKINNABLE_SLEEP.accept(blockEntity, player)) {
            class_2680 bedState = (class_2680)class_2246.field_10069.method_9564().method_11657(PART, (Comparable)class_2742.field_12560);
            return super.method_55766(bedState, level, blockEntity.getBedPos(), player, blockHitResult);
        }
        if (blockEntity.isSeat() && !player.method_21823() && ModPermissions.SKINNABLE_SIT.accept(blockEntity, player)) {
            if (level.method_8608()) {
                return class_1269.field_21466;
            }
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            SeatEntity seatEntity = this.getSeatEntity((class_3218)level, blockEntity.getParentPos(), seatPos);
            if (seatEntity == null) {
                return class_1269.field_5814;
            }
            player.method_5873((class_1297)seatEntity, true);
            return class_1269.field_5812;
        }
        if (blockEntity.isInventory()) {
            class_1269 result = ((IMenuType)ModMenuTypes.SKINNABLE.get()).openMenu(player, level.method_8321(blockPos));
            if (result.method_23665()) {
                player.method_7259(class_3468.field_15419.method_14956((Object)class_3468.field_15395));
            }
            return result;
        }
        return class_1269.field_5814;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        SkinBlockPlaceContext context1;
        class_2680 state = super.method_9605(context);
        if (state != null && context instanceof SkinBlockPlaceContext && (context1 = (SkinBlockPlaceContext)context).getProperty(SkinProperty.BLOCK_GLOWING).booleanValue()) {
            state = (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public class_1799 method_9574(class_4538 blockGetter, class_2338 blockPos, class_2680 blockState) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((class_1922)blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSkin().asItemStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean isCustomBed(class_1922 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1297 player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isBed();
        }
        return false;
    }

    @Override
    public boolean isCustomLadder(class_1922 level, class_2338 blockPos, class_2680 blockState, class_1309 entity) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isLadder();
        }
        return false;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, FACE, LIT, PART, OCCUPIED});
    }

    public boolean method_9498(class_2680 blockState) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((class_1922)level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getAnalogOutputSignal();
        }
        return 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 blockPos, class_2350 direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSignal(direction);
        }
        return 0;
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 blockPos, class_2350 direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getDirectSignal(direction);
        }
        return 0;
    }

    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return class_259.method_1073();
    }

    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getCollisionShape();
        }
        return class_259.method_1073();
    }

    public void forEach(class_1937 level, class_2338 pos, Consumer<class_2338> consumer) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((class_1922)level, pos);
        if (blockEntity == null) {
            return;
        }
        class_2338 parentPos = blockEntity.method_11016();
        for (class_2338 offset : blockEntity.getRefers()) {
            class_2338 targetPos = parentPos.method_10081((class_2382)offset);
            if (targetPos.equals((Object)pos)) continue;
            consumer.accept(targetPos);
        }
    }

    public void brokenByAnything(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1657 player) {
        if (this.dropItems(level, blockPos, player)) {
            this.killSeatEntities(level, blockPos);
            this.forEach(level, blockPos, target -> level.method_8652(target, class_2246.field_10124.method_9564(), 35));
        }
    }

    public void killSeatEntities(class_1937 level, class_2338 blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((class_1922)level, blockPos);
        if (blockEntity != null) {
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            this.killSeatEntity(level, blockEntity.getParentPos(), seatPos);
        }
    }

    public boolean dropItems(class_1937 level, class_2338 blockPos, @Nullable class_1657 player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((class_1922)level, blockPos);
        SkinnableBlockEntity parentBlockEntity = this.getParentBlockEntity((class_1922)level, blockPos);
        if (blockEntity == null || parentBlockEntity == null || parentBlockEntity.isDropped()) {
            return false;
        }
        class_1799 droppedStack = parentBlockEntity.getSkin().asItemStack();
        blockEntity.setDropped(droppedStack);
        parentBlockEntity.setDropped(droppedStack);
        if (parentBlockEntity.isInventory()) {
            DataSerializers.dropContents(level, blockPos, (class_1263)parentBlockEntity);
        }
        return true;
    }

    private SkinnableBlockEntity getBlockEntity(class_1922 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            SkinnableBlockEntity blockEntity1 = (SkinnableBlockEntity)blockEntity;
            return blockEntity1;
        }
        return null;
    }

    private SkinnableBlockEntity getParentBlockEntity(class_1922 level, class_2338 blockPos) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getParent();
        }
        return null;
    }

    @Nullable
    private SeatEntity getSeatEntity(class_3218 level, class_2338 blockPos, OpenVector3d pos) {
        class_238 searchRect = new class_238(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.method_18467(SeatEntity.class, searchRect)) {
            if (!entity.method_5805() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            if (entity.method_5685().isEmpty()) {
                return entity;
            }
            return null;
        }
        SeatEntity entity = (SeatEntity)((IEntityType)ModEntityTypes.SEAT.get()).create(level, class_2338.field_10980, null, class_3730.field_16465);
        entity.method_5814(pos.x(), pos.y(), pos.z());
        entity.setBlockPos(blockPos);
        level.method_8649((class_1297)entity);
        return entity;
    }

    private void killSeatEntity(class_1937 level, class_2338 blockPos, OpenVector3d pos) {
        class_238 searchRect = new class_238(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.method_18467(SeatEntity.class, searchRect)) {
            if (!entity.method_5805() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            entity.method_5768();
        }
    }
}

