/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.compatibility.client.layer.AbstractSkinnableLayers;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.layer.PlaceholderLayer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3887;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;

public abstract class DefaultLayerArmaturePlugin
extends ArmaturePlugin {
    private IModel entityModel;
    private class_897<?> entityRenderer;
    protected final ArrayList<Applier<?, ?>> applying = new ArrayList();

    public DefaultLayerArmaturePlugin(ArmatureTransformerContext context) {
        context.addEntityModelListener(entityModel -> {
            this.entityModel = entityModel;
        });
        context.addEntityRendererListener(entityRenderer -> {
            this.entityRenderer = entityRenderer;
        });
    }

    public static DefaultLayerArmaturePlugin any(ArmatureTransformerContext context) {
        Blacklist plugin = new Blacklist(context, DefaultLayerArmaturePlugin::whenAnyVisible);
        plugin.register(SkinWardrobeLayer.class);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin villager(ArmatureTransformerContext context) {
        Whitelist plugin = new Whitelist(context);
        plugin.register(AbstractSkinnableLayers.VILLAGER_PROFESSION, DefaultLayerArmaturePlugin::whenHeadVisible);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin mob(ArmatureTransformerContext context) {
        Whitelist plugin = new Whitelist(context);
        plugin.register(AbstractSkinnableLayers.STRAY_CLOTHING, DefaultLayerArmaturePlugin::whenBodyVisible);
        plugin.register(AbstractSkinnableLayers.DROWNED_OUTER, DefaultLayerArmaturePlugin::whenBodyVisible);
        return plugin;
    }

    public static BooleanSupplier whenHeadVisible(IModel model) {
        IModelPart modelPart = model.partByName("head");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    public static BooleanSupplier whenAnyVisible(IModel model) {
        Iterator<? extends IModelPart> iterator = model.allParts().iterator();
        if (iterator.hasNext()) {
            IModelPart part = iterator.next();
            return part::isVisible;
        }
        return null;
    }

    public static BooleanSupplier whenBodyVisible(IModel model) {
        IModelPart modelPart = model.partByName("body");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    public abstract <T extends class_1309, M extends class_583<T>> Selector search(class_3887<T, M> var1);

    @Override
    public void activate(class_1297 entity, ArmaturePlugin.Context context) {
        this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)Applier::activate));
    }

    @Override
    public void deactivate(class_1297 entity, ArmaturePlugin.Context context) {
        this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)Applier::deactivate));
    }

    @Override
    public boolean freeze() {
        if (this.entityModel != null && this.entityRenderer != null) {
            this.buildRules(this.entityModel, this.entityRenderer);
            this.entityModel = null;
            this.entityRenderer = null;
        }
        return !this.applying.isEmpty();
    }

    private void buildRules(IModel entityModel, class_897<?> entityRenderer) {
        if (entityRenderer instanceof class_922) {
            class_922 livingEntityRenderer = (class_922)entityRenderer;
            this.buildRules(livingEntityRenderer);
        }
        if (entityModel != null) {
            this.applying.forEach((Consumer<Applier<?, ?>>)((Consumer<Applier>)it -> {
                it.selector.tester = it.selector.testFactory.apply(entityModel);
            }));
            this.applying.removeIf(it -> it.selector.tester == null);
        }
    }

    private <T extends class_1309, M extends class_583<T>> void buildRules(class_922<T, M> entityRenderer) {
        for (class_3887 layer : entityRenderer.field_4738) {
            Selector entry = this.search(layer);
            if (entry == null) continue;
            Applier applier = new Applier(entry);
            applier.target = layer;
            applier.placeholder = new PlaceholderLayer<T, M>(entityRenderer);
            applier.layers = () -> entityRenderer.field_4738;
            this.applying.add(applier);
        }
    }

    public static class Blacklist
    extends DefaultLayerArmaturePlugin {
        protected final ArrayList<Class<?>> blocked = new ArrayList();
        protected final Function<IModel, BooleanSupplier> testFactory;

        public Blacklist(ArmatureTransformerContext context, Function<IModel, BooleanSupplier> testFactory) {
            super(context);
            this.testFactory = testFactory;
        }

        public void register(Class<?> clazz) {
            this.blocked.add(clazz);
        }

        @Override
        public <T extends class_1309, M extends class_583<T>> Selector search(class_3887<T, M> layer) {
            for (Class<?> layerClass : this.blocked) {
                if (!layerClass.isInstance(layer)) continue;
                return null;
            }
            return new Selector(layer.getClass(), this.testFactory);
        }
    }

    public static class Whitelist
    extends DefaultLayerArmaturePlugin {
        protected final ArrayList<Selector> selectors = new ArrayList();

        public Whitelist(ArmatureTransformerContext context) {
            super(context);
        }

        public void register(Class<?> clazz, Function<IModel, BooleanSupplier> testFactory) {
            if (clazz != null) {
                this.selectors.add(new Selector(clazz, testFactory));
            }
        }

        @Override
        public <T extends class_1309, M extends class_583<T>> Selector search(class_3887<T, M> layer) {
            for (Selector entry : this.selectors) {
                if (!entry.layerClass.isInstance(layer)) continue;
                return entry;
            }
            return null;
        }
    }

    public static class Selector {
        private final Class<?> layerClass;
        private final Function<IModel, BooleanSupplier> testFactory;
        private BooleanSupplier tester;

        public Selector(Class<?> layerClass, Function<IModel, BooleanSupplier> testFactory) {
            this.layerClass = layerClass;
            this.testFactory = testFactory;
        }
    }

    public static class Applier<T extends class_1297, M extends class_583<T>> {
        private final Selector selector;
        private class_3887<T, M> target;
        private class_3887<T, M> placeholder;
        private Supplier<List<class_3887<T, M>>> layers;
        private int lastIndex = -1;
        private boolean isEnabled = false;

        public Applier(Selector selector) {
            this.selector = selector;
        }

        public void activate() {
            if (!this.isEnabled && !this.selector.tester.getAsBoolean()) {
                this.replace(this.target, this.placeholder);
                this.isEnabled = true;
            }
        }

        public void deactivate() {
            if (this.isEnabled) {
                this.replace(this.placeholder, this.target);
                this.isEnabled = false;
            }
        }

        private void replace(class_3887<T, M> from, class_3887<T, M> to) {
            List<class_3887<T, M>> layers = this.layers.get();
            if (this.lastIndex >= 0 && this.lastIndex < layers.size() && layers.get(this.lastIndex) == from) {
                layers.set(this.lastIndex, to);
                return;
            }
            for (int index = 0; index < layers.size(); ++index) {
                if (layers.get(index) != from) continue;
                layers.set(index, to);
                this.lastIndex = index;
                break;
            }
        }
    }
}

