/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.fabric;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.LoginPacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_635;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AbstractFabricNetwork {

    public static class Proxy
    implements class_8710 {
        public static class_8710.class_9154<Proxy> TYPE;
        public static class_9139<class_9129, Proxy> CODEC;
        public final IFriendlyByteBuf payload;

        public Proxy(IFriendlyByteBuf buffer) {
            this.payload = buffer;
        }

        public class_8710.class_9154<Proxy> method_56479() {
            return TYPE;
        }

        static {
            CODEC = new class_9139<class_9129, Proxy>(){

                public Proxy decode(class_9129 bufferIn) {
                    ByteBuf buffer = bufferIn.retainedSlice();
                    class_9129 duplicated = new class_9129(buffer, bufferIn.method_56349());
                    bufferIn.method_52994(bufferIn.readableBytes());
                    return new Proxy(IFriendlyByteBuf.wrap((ByteBuf)duplicated));
                }

                public void encode(class_9129 buf, Proxy proxy) {
                    ByteBuf sending = proxy.payload.asByteBuf();
                    buf.method_52975(sending.slice());
                }
            };
        }
    }

    public static enum LogicalSide {
        CLIENT,
        SERVER;


        public boolean isServer() {
            return !this.isClient();
        }

        public boolean isClient() {
            return this == CLIENT;
        }
    }

    public static class Distributors
    implements NetworkManager.Distributors {
        @Override
        public IPacketDistributor trackingChunk(Supplier<class_2818> supplier) {
            class_2818 chunk = supplier.get();
            class_3218 serverLevel = (class_3218)chunk.method_12200();
            Collection players = PlayerLookup.tracking((class_3218)serverLevel, (class_1923)chunk.method_12004());
            return new Distributor(LogicalSide.SERVER, this.dispatch(players), null);
        }

        @Override
        public IPacketDistributor trackingEntityAndSelf(Supplier<class_1297> supplier) {
            class_1297 entity = supplier.get();
            ArrayList<class_3222> players = PlayerLookup.tracking((class_1297)entity);
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ArrayList<class_3222> trackingAndSelf = new ArrayList<class_3222>(players);
                trackingAndSelf.add(player);
                players = trackingAndSelf;
            }
            return new Distributor(LogicalSide.SERVER, this.dispatch((Collection<class_3222>)players), null);
        }

        @Override
        public IPacketDistributor player(Supplier<class_3222> supplier) {
            class_3222 player = supplier.get();
            return new Distributor(LogicalSide.SERVER, this.dispatch(Collections.singleton(player)), null);
        }

        @Override
        public IPacketDistributor allPlayers() {
            return new Distributor(LogicalSide.SERVER, this.dispatch(PlayerLookup.all((MinecraftServer)EnvironmentManager.getServer())), null);
        }

        @Override
        public IPacketDistributor server() {
            return new Distributor(LogicalSide.CLIENT, arg_0 -> ((PacketSender)ClientPlayNetworking.getSender()).sendPacket(arg_0), null);
        }

        private Consumer<class_8710> dispatch(Collection<class_3222> players) {
            return packet -> players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)packet));
        }
    }

    public static class Distributor
    implements IPacketDistributor {
        private final LogicalSide sender;
        private final Consumer<class_8710> target;
        private final class_8710 packet;

        Distributor(LogicalSide sender, Consumer<class_8710> target, class_8710 packet) {
            this.sender = sender;
            this.target = target;
            this.packet = packet;
        }

        @Override
        public IPacketDistributor add(IResourceLocation channel, IFriendlyByteBuf buf) {
            return new Distributor(this.sender, this.target, new Proxy(buf));
        }

        @Override
        public void execute() {
            if (this.packet != null) {
                this.target.accept(this.packet);
            }
        }

        @Override
        public boolean isClientbound() {
            return this.sender.isServer();
        }
    }

    public static class Dispatcher
    extends NetworkManager.Dispatcher {
        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            super(channelName, channelVersion);
        }

        @Override
        public void register() {
            Proxy.TYPE = new class_8710.class_9154(this.channelName.toLocation());
            PayloadTypeRegistry.playC2S().register(Proxy.TYPE, Proxy.CODEC);
            PayloadTypeRegistry.playS2C().register(Proxy.TYPE, Proxy.CODEC);
            ServerLoginConnectionEvents.QUERY_START.register(this::startServerHandshake);
            ServerLoginNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onServerHandshake);
            ServerPlayNetworking.registerGlobalReceiver(Proxy.TYPE, this::onServerEvent);
            EnvironmentExecutor.runOn(EnvironmentType.CLIENT, () -> () -> {
                ClientLoginNetworking.registerGlobalReceiver((class_2960)this.channelName.toLocation(), this::onClientHandshake);
                ClientPlayNetworking.registerGlobalReceiver(Proxy.TYPE, this::onClientEvent);
            });
        }

        public void startServerHandshake(Object handler, MinecraftServer server, LoginPacketSender sender, ServerLoginNetworking.LoginSynchronizer synchronizer) {
            if (ModConfig.Common.enableProtocolCheck) {
                sender.sendPacket(this.channelName.toLocation(), PacketByteBufs.empty());
            }
        }

        public void onServerHandshake(MinecraftServer server, class_3248 handler, boolean understood, class_2540 buf, ServerLoginNetworking.LoginSynchronizer synchronizer, PacketSender responseSender) {
            String version;
            if (!ModConfig.Common.enableProtocolCheck) {
                return;
            }
            if (understood && (version = buf.method_19772()).equals(this.channelVersion)) {
                return;
            }
            handler.method_14380((class_2561)class_2561.method_43470((String)"Please install correct Armourers Workshop to play on this server!"));
        }

        @Environment(value=EnvType.CLIENT)
        public CompletableFuture<@Nullable class_2540> onClientHandshake(class_310 client, class_635 handler, class_2540 buf, Consumer<class_7648> consumer) {
            class_2540 responseBuffer = new class_2540(Unpooled.buffer());
            responseBuffer.method_10814(this.channelVersion);
            return CompletableFuture.completedFuture(responseBuffer);
        }

        public void onServerEvent(Proxy proxy, ServerPlayNetworking.Context context) {
            IServerPacketHandler packetHandler = arg_0 -> ((MinecraftServer)context.player().field_13995).execute(arg_0);
            this.didReceivePacket(packetHandler, proxy.payload, context.player());
        }

        @Environment(value=EnvType.CLIENT)
        public void onClientEvent(Proxy proxy, ClientPlayNetworking.Context context) {
            IClientPacketHandler packetHandler = arg_0 -> ((class_310)context.client()).execute(arg_0);
            this.didReceivePacket(packetHandler, proxy.payload, null);
        }
    }
}

