/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.serialization.Codec;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class AbstractDataComponentType<T>
implements class_9331<T>,
IDataComponentType<T> {
    protected final class_9331<T> key;
    protected final String tag;
    protected final IDataCodec<T> codec;
    protected final class_9139<? super class_9129, T> streamCodec;

    public AbstractDataComponentType(String tag, IDataCodec<T> codec) {
        this.tag = tag;
        this.codec = codec;
        this.streamCodec = class_9135.method_56896(codec.codec());
        this.key = this;
    }

    public static <T> AbstractDataComponentType<T> create(String tag, IDataCodec<T> codec) {
        if (tag.equals("EntityTag")) {
            return new Proxy<T>((class_9331<class_9279>)class_9334.field_49609, tag, codec);
        }
        if (tag.equals("BlockEntityTag")) {
            return new Proxy<T>((class_9331<class_9279>)class_9334.field_49611, tag, codec);
        }
        return new AbstractDataComponentType<T>(tag, codec);
    }

    public boolean isProxy() {
        return this instanceof Proxy;
    }

    @Override
    public boolean has(class_1799 itemStack) {
        return itemStack.method_57826(this.key);
    }

    @Override
    public void set(class_1799 itemStack, @Nullable T value) {
        itemStack.method_57379(this.key, value);
    }

    @Override
    @Nullable
    public T get(class_1799 itemStack) {
        return (T)itemStack.method_57824(this.key);
    }

    @Override
    public T getOrDefault(class_1799 itemStack, T defaultValue) {
        return (T)itemStack.method_57825(this.key, defaultValue);
    }

    @Override
    public void remove(class_1799 itemStack) {
        itemStack.method_57381(this.key);
    }

    @Nullable
    public Codec<T> method_57875() {
        return this.codec.codec();
    }

    public class_9139<? super class_9129, T> method_57878() {
        return this.streamCodec;
    }

    public static class Proxy<T>
    extends AbstractDataComponentType<T> {
        protected final class_9331<class_9279> target;

        public Proxy(class_9331<class_9279> target, String tag, IDataCodec<T> codec) {
            super(tag, codec);
            this.target = target;
        }

        @Override
        public boolean has(class_1799 itemStack) {
            return itemStack.method_57826(this.target);
        }

        @Override
        public void set(class_1799 itemStack, @Nullable T value) {
            if (value != null) {
                itemStack.method_57379(this.target, (Object)class_9279.method_57456((class_2487)this.encode(value)));
            } else {
                itemStack.method_57379(this.target, null);
            }
        }

        @Override
        @Nullable
        public T get(class_1799 itemStack) {
            class_9279 customData = (class_9279)itemStack.method_57824(this.target);
            if (customData != null) {
                return this.decode(customData.method_57463());
            }
            return null;
        }

        @Override
        public T getOrDefault(class_1799 itemStack, T defaultValue) {
            class_9279 customData = (class_9279)itemStack.method_57824(this.target);
            if (customData != null) {
                return this.decode(customData.method_57463());
            }
            return defaultValue;
        }

        @Override
        public void remove(class_1799 itemStack) {
            itemStack.method_57381(this.target);
        }

        private class_2487 encode(T value) {
            return (class_2487)Objects.unsafeCast(value);
        }

        private T decode(class_2487 tag) {
            return Objects.unsafeCast(tag);
        }
    }
}

