/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class AbstractRegistryResolver {
    private static final Map<String, Optional<class_6862<class_1792>>> NAMED_ITEM_TAGS = new ConcurrentHashMap<String, Optional<class_6862<class_1792>>>();
    private static final Map<String, Optional<class_6862<class_2248>>> NAMED_BLOCK_TAGS = new ConcurrentHashMap<String, Optional<class_6862<class_2248>>>();
    private static final Map<String, Optional<class_6862<class_1959>>> NAMED_BIOME_TAGS = new ConcurrentHashMap<String, Optional<class_6862<class_1959>>>();
    private static final Map<String, Optional<? extends class_6880<class_1320>>> NAMED_ATTRIBUTES = new ConcurrentHashMap<String, Optional<? extends class_6880<class_1320>>>();
    private static final Map<String, Optional<? extends class_6880<class_1291>>> NAMED_EFFECTS = new ConcurrentHashMap<String, Optional<? extends class_6880<class_1291>>>();
    private static final Map<String, Optional<? extends class_6880<class_1887>>> NAMED_ENCHANTMENTS = new ConcurrentHashMap<String, Optional<? extends class_6880<class_1887>>>();

    public static String getItemKey(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).toString();
    }

    public static String getBlockKey(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).toString();
    }

    public static boolean hasItemTag(class_1799 itemStack, String tagName) {
        Optional tag = NAMED_ITEM_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, class_7924.field_41197));
        return tag.map(arg_0 -> ((class_1799)itemStack).method_31573(arg_0)).orElse(false);
    }

    public static boolean hasBlockTag(class_2680 blockState, String tagName) {
        Optional tag = NAMED_BLOCK_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, class_7924.field_41254));
        return tag.map(arg_0 -> ((class_2680)blockState).method_26164(arg_0)).orElse(false);
    }

    public static boolean hasBiomeTag(Object biome, String tagName) {
        class_6880 biome1 = (class_6880)Objects.unsafeCast(biome);
        Optional tag = NAMED_BIOME_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, class_7924.field_41236));
        return tag.map(arg_0 -> ((class_6880)biome1).method_40220(arg_0)).orElse(false);
    }

    @Nullable
    public static Object getBiome(class_1937 level, class_2338 blockPos) {
        return level.method_23753(blockPos);
    }

    @Nullable
    public static class_1293 getEffect(class_1309 entity, String effectName) {
        Optional value = NAMED_EFFECTS.computeIfAbsent(effectName, it -> AbstractRegistryResolver.findValue(it, class_7924.field_41208));
        return value.map(arg_0 -> ((class_1309)entity).method_6112(arg_0)).orElse(null);
    }

    public static double getAttribute(class_1309 entity, String attributeName) {
        Optional value = NAMED_ATTRIBUTES.computeIfAbsent(attributeName, it -> AbstractRegistryResolver.findValue(it, class_7924.field_41251));
        return value.map(arg_0 -> ((class_1309)entity).method_45325(arg_0)).orElse(0.0);
    }

    public static Object getEnchantment(class_1799 itemStack, String enchantmentName) {
        Optional value = NAMED_ENCHANTMENTS.computeIfAbsent(enchantmentName, it -> AbstractRegistryResolver.findValue(it, class_7924.field_41265));
        return value.map(it -> class_1890.method_8225((class_6880)it, (class_1799)itemStack)).orElse(null);
    }

    private static <T> Optional<class_6862<T>> findTag(String name, class_5321<? extends class_2378<T>> resourceKey) {
        class_2960 key = class_2960.method_12829((String)name);
        if (key != null) {
            return Optional.of(class_6862.method_40092(resourceKey, (class_2960)key));
        }
        return Optional.empty();
    }

    private static <T> Optional<? extends class_6880<T>> findValue(String name, class_5321<? extends class_2378<T>> resourceKey) {
        class_2960 key = class_2960.method_12829((String)name);
        if (key == null) {
            return Optional.empty();
        }
        class_5455 registryAccess = AbstractRegistryResolver.findRegistryAccess();
        if (registryAccess == null) {
            return Optional.empty();
        }
        class_2378 registry = registryAccess.method_33310(resourceKey).orElse(null);
        if (registry == null) {
            return Optional.empty();
        }
        return registry.method_55841(key);
    }

    protected static class_5455 findRegistryAccess() {
        MinecraftServer server = EnvironmentManager.getServer();
        if (server != null) {
            return server.method_30611();
        }
        Optional<Object> client = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> {
            class_634 connection = class_310.method_1551().method_1562();
            if (connection != null) {
                return connection.method_29091();
            }
            return null;
        });
        return client.orElse(null);
    }
}

