/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPartCollector;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelCollector;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelPartHolder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.Model.BabyPose;
import moe.plushie.armourers_workshop.core.client.model.CachedModel;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3879;
import net.minecraft.class_583;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class AbstractModelHolder {
    private static final HashMap<Class<?>, Entry<?, ?>> ENTRIES = new HashMap();

    public static <V extends class_3879, M extends IModel> M ofNullable(V model) {
        if (model != null) {
            return AbstractModelHolder.of(model);
        }
        return null;
    }

    public static <M extends IModel> M of(class_3879 model) {
        IModel holder = DataContainer.getOrDefault(model, null);
        if (holder != null) {
            return (M)holder;
        }
        holder = AbstractModelHolder.createHolder(model);
        DataContainer.set(model, holder);
        return (M)holder;
    }

    public static <T extends class_3879> void register(Class<T> clazz, Map<String, String> mapper) {
        ENTRIES.put(clazz, new Entry(clazz, null, AbstractModelCollector.apply(clazz, mapper)));
    }

    private static <V extends class_3879, M extends IModel> M createHolder(V model) {
        HashSet<Entry<V, M>> exists = new HashSet<Entry<V, M>>();
        ArrayList<Map> builders = new ArrayList<Map>();
        Function factory = null;
        for (Class<?> clazz = model.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Entry<V, M> entry = AbstractModelHolder.getEntry(clazz);
            if (entry == null || !exists.add(entry)) continue;
            builders.add(entry.mapper);
            if (factory != null) continue;
            factory = entry.factory;
        }
        if (factory == null) {
            Function<Container, CachedModel> factory1 = CachedModel::new;
            factory = (Function)Objects.unsafeCast(factory1);
        }
        Container container = new Container(model);
        Map<String, class_630> allParts = AbstractModelHolder.parseModel(model);
        builders.forEach(mapper -> mapper.forEach((target, source) -> {
            class_630 part = (class_630)allParts.remove(source);
            if (part != null) {
                container.put((String)target, part);
            }
        }));
        allParts.forEach((key, part) -> {
            if (!key.contains(".")) {
                container.unnamed(Collections.singleton(part));
            }
        });
        return (M)((IModel)factory.apply(container));
    }

    private static <V extends class_3879, M extends IModel> Entry<V, M> getEntry(Class<?> clazz) {
        Entry<Object, Object> entry = ENTRIES.get(clazz);
        if (entry == null) {
            if (clazz == Object.class) {
                return null;
            }
            entry = AbstractModelHolder.getEntry(clazz.getSuperclass());
            ENTRIES.put(clazz, entry);
        }
        return (Entry)Objects.unsafeCast(entry);
    }

    private static Map<String, class_630> parseModel(class_3879 model) {
        LinkedHashMap<String, class_630> allParts = new LinkedHashMap<String, class_630>();
        if (model instanceof IModelPartCollector) {
            IModelPartCollector provider = (IModelPartCollector)model;
            provider.aw2$collect(allParts);
        }
        return allParts;
    }

    private static class Entry<T extends class_3879, M extends IModel> {
        Class<T> clazz;
        Function<Container, M> factory;
        Map<String, String> mapper;

        Entry(Class<T> clazz, Function<Container, M> factory, Map<String, String> mapper) {
            this.clazz = clazz;
            this.factory = factory;
            this.mapper = mapper;
        }
    }

    private static class Container
    extends CachedModel.Container<class_630> {
        private final class_583<?> model;

        public Container(class_3879 model) {
            super(model.getClass(), AbstractModelPartHolder::of);
            this.model = Objects.safeCast(model, class_583.class);
            this.babyPose = BabyPose.getBabyPose(model);
        }

        @Override
        public IModelBabyPose babyPose() {
            if (this.model != null && this.model.field_3448) {
                return super.babyPose();
            }
            return null;
        }
    }
}

