/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.EntityRendererImpl;
import com.apple.library.uikit.UIFont;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRendererImpl;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private final class_332 graphics;
    private final CGPoint mousePos;
    private final IPoseStack poseStack;
    private final IBufferSource bufferSource;
    private final float partialTicks;

    public AbstractGraphicsRenderer(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.graphics = graphics;
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.poseStack = AbstractPoseStack.wrap(graphics.method_51448());
        this.bufferSource = AbstractBufferSource.wrap((class_4597)graphics.method_51450());
        this.partialTicks = partialTicks;
    }

    public static class_332 of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)Objects.unsafeCast(context.state());
        return impl.graphics;
    }

    public static CGGraphicsContext of(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(graphics, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, UIFont font, CGGraphicsContext context) {
        class_327 font1 = font.impl();
        List texts = font1.method_1728((class_5348)text.component(), 100000);
        this.graphics.method_51447(font1, texts, (int)this.mousePos.x(), (int)this.mousePos.y());
    }

    @Override
    public void renderTooltip(class_1799 itemStack, CGRect rect, UIFont font, CGGraphicsContext context) {
        class_327 font1 = font.impl();
        this.graphics.method_51446(font1, itemStack, (int)this.mousePos.x(), (int)this.mousePos.y());
    }

    @Override
    public void renderEntity(class_1297 entity, CGPoint origin, int scale, CGPoint focus, CGGraphicsContext context) {
        EntityRendererImpl<class_1297> renderer = AbstractGraphicsRendererImpl.getRenderer(entity);
        renderer.render(entity, origin, scale, focus, context);
    }

    @Override
    public void renderItem(class_1799 itemStack, int x, int y, CGGraphicsContext context) {
        this.graphics.method_51445(itemStack, x, y);
    }

    @Override
    public void flush() {
        this.graphics.method_51452();
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public IBufferSource bufferSource() {
        return this.bufferSource;
    }

    @Override
    public IPoseStack ctm() {
        return this.poseStack;
    }
}

