/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDeltaTracker;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.CustomRiddingProvider;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.init.event.client.RenderFrameEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1498;

public class AbstractVehicleUpdater {
    private static final AbstractVehicleUpdater INSTANCE = new AbstractVehicleUpdater();
    private final Int2ObjectMap<class_1297> entities = new Int2ObjectOpenHashMap();
    private Int2ObjectMap<class_1297> active;

    private AbstractVehicleUpdater() {
        EventBus.register(RenderFrameEvent.Pre.class, event -> this.update(event.getDeltaTracker()));
    }

    public static AbstractVehicleUpdater getInstance() {
        return INSTANCE;
    }

    public void submit(class_1297 entity) {
        this.active = this.entities;
        this.entities.put(entity.method_5628(), (Object)entity);
    }

    private void update(AbstractDeltaTracker delta) {
        if (this.active == null) {
            return;
        }
        ArrayList<class_1297> oldValue = new ArrayList<class_1297>((Collection<class_1297>)this.entities.values());
        this.active = null;
        this.entities.clear();
        oldValue.forEach(it -> this.apply((class_1297)it, delta.getPartialTick((class_1297)it)));
    }

    private void apply(class_1297 entity, float partialTicks) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        List passengers = entity.method_5685();
        for (int index = 0; index < passengers.size(); ++index) {
            SkinAttachmentPose attachmentPose = renderData.getAttachmentPose(SkinAttachmentTypes.RIDING, index);
            if (attachmentPose == null) continue;
            class_1297 passenger = (class_1297)passengers.get(index);
            this.apply(entity, partialTicks, index, passenger, attachmentPose);
        }
    }

    private void apply(class_1297 entity, float partialTicks, int index, class_1297 passenger, SkinAttachmentPose pose) {
        float scale = this.getRiddingScale(entity);
        OpenMatrix4f mat = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        mat.rotate(OpenVector3f.YP.rotationDegrees(180.0f - entity.method_5705(partialTicks)));
        mat.scale(-1.0f, -1.0f, 1.0f);
        mat.scale(scale, scale, scale);
        mat.translate(0.0f, -1.501f, 0.0f);
        mat.scale(0.0625f, 0.0625f, 0.0625f);
        mat.multiply(pose.pose());
        OpenVector3f offset = OpenVector3f.ZERO.transforming(mat);
        CustomRiddingProvider.setCustomRidding(entity, index, offset);
        double tx = passenger.method_23317();
        double ty = passenger.method_23318();
        double tz = passenger.method_23321();
        entity.method_24201(passenger);
        double dx = passenger.method_23317() - tx;
        double dy = passenger.method_23318() - ty;
        double dz = passenger.method_23321() - tz;
        passenger.field_6014 += dx;
        passenger.field_6036 += dy;
        passenger.field_5969 += dz;
        passenger.field_6038 += dx;
        passenger.field_5971 += dy;
        passenger.field_5989 += dz;
    }

    private float getRiddingScale(class_1297 entity) {
        if (entity instanceof class_1498) {
            return 1.1f;
        }
        return 1.0f;
    }
}

