/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStackImpl;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class AbstractPoseStack
extends AbstractPoseStackImpl
implements IPoseStack {
    private final class_4587 stack;

    public AbstractPoseStack() {
        this(new class_4587());
    }

    public AbstractPoseStack(class_4587 poseStack) {
        this.stack = poseStack;
    }

    public static OpenPoseStack create(IPoseStack poseStack) {
        OpenPoseStack poseStack1 = (OpenPoseStack)REUSABLE_QUEUE.get();
        poseStack1.last().set(poseStack.last());
        return poseStack1;
    }

    public static OpenPoseStack create(class_4587 poseStack) {
        OpenPoseStack poseStack1 = (OpenPoseStack)REUSABLE_QUEUE.get();
        poseStack1.last().set(DataContainer.of(poseStack.method_23760(), Pose::new));
        return poseStack1;
    }

    public static void reset(class_4587 poseStack) {
        poseStack.method_22905(1.0E-9f, 1.0E-9f, 1.0E-9f);
    }

    public static IPoseStack wrap(class_4587 poseStack) {
        return DataContainer.of(poseStack, AbstractPoseStack::new);
    }

    public static class_4587 unwrap(IPoseStack poseStack) {
        if (poseStack instanceof AbstractPoseStack) {
            AbstractPoseStack poseStack1 = (AbstractPoseStack)poseStack;
            return poseStack1.stack;
        }
        class_4587 poseStack1 = new class_4587();
        IPoseStack poseStack2 = AbstractPoseStack.wrap(poseStack1);
        poseStack2.last().set(poseStack.last());
        return poseStack1;
    }

    @Override
    public void pushPose() {
        this.stack.method_22903();
    }

    @Override
    public void popPose() {
        this.stack.method_22909();
    }

    @Override
    public void translate(float x, float y, float z) {
        this.stack.method_46416(x, y, z);
    }

    @Override
    public void scale(float x, float y, float z) {
        Pose entry = this.last();
        entry.pose.scale(x, y, z);
        if (Math.abs(x) == Math.abs(y) && Math.abs(y) == Math.abs(z)) {
            if (x < 0.0f || y < 0.0f || z < 0.0f) {
                entry.normal.scale(Math.signum(x), Math.signum(y), Math.signum(z));
            }
        } else {
            entry.normal.scale(1.0f / x, 1.0f / y, 1.0f / z);
            entry.properties |= 2;
        }
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        ABI.mulPose(this.stack, quaternion);
    }

    @Override
    public void multiply(IMatrix3f matrix) {
        Pose entry = this.last();
        entry.normal.multiply(matrix);
    }

    @Override
    public void multiply(IMatrix4f matrix) {
        Pose entry = this.last();
        entry.pose.multiply(matrix);
    }

    @Override
    public void setIdentity() {
        this.stack.method_34426();
        this.last().setProperties(0);
    }

    @Override
    public Pose last() {
        return DataContainer.of(this.stack.method_23760(), Pose::new);
    }

    public static class Pose
    implements IPoseStack.Pose {
        private final AbstractPoseStackImpl.AbstractMatrix4f pose;
        private final AbstractPoseStackImpl.AbstractMatrix3f normal;
        private int properties;

        public Pose(class_4587.class_4665 pose) {
            this.pose = new AbstractPoseStackImpl.AbstractMatrix4f(pose.method_23761());
            this.normal = new AbstractPoseStackImpl.AbstractMatrix3f(pose.method_23762());
            this.properties = 0;
        }

        @Override
        public void transformPose(float[] values) {
            this.pose.multiply(values);
        }

        @Override
        public void transformNormal(float[] values) {
            this.normal.multiply(values);
            if ((this.properties & 2) != 0) {
                OpenMath.normalize(values);
            }
        }

        @Override
        public void set(IPoseStack.Pose entry) {
            this.pose.set(entry.pose());
            this.normal.set(entry.normal());
            this.properties = entry.properties();
        }

        @Override
        public IMatrix4f pose() {
            return this.pose;
        }

        @Override
        public IMatrix3f normal() {
            return this.normal;
        }

        public void setProperties(int properties) {
            this.properties = properties;
        }

        @Override
        public int properties() {
            return this.properties;
        }
    }
}

