/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class WorldUpdater {
    private static final WorldUpdater INSTANCE = new WorldUpdater();
    private final LinkedList<IWorldUpdateTask> failedTasks = new LinkedList();
    private final HashMap<class_5321<class_1937>, AutoMergeQueue> allTasks = new HashMap();

    public static WorldUpdater getInstance() {
        return INSTANCE;
    }

    public synchronized void submit(IWorldUpdateTask task) {
        this.allTasks.computeIfAbsent((class_5321<class_1937>)task.level().method_27983(), k -> new AutoMergeQueue()).push(task);
    }

    public void tick(class_1937 level) {
        class_5321 key = level.method_27983();
        if (this.isEmpty((class_5321<class_1937>)key)) {
            return;
        }
        BlockUtils.performBatch(() -> {
            IWorldUpdateTask task;
            int count = ModConfig.Common.blockTaskRate;
            while (count > 0 && (task = this.poll((class_5321<class_1937>)key)) != null) {
                class_1269 resultType = task.run(level);
                if (resultType.method_23665()) {
                    --count;
                    continue;
                }
                if (resultType != class_1269.field_5814) continue;
                this.failedTasks.add(task);
            }
            if (!this.failedTasks.isEmpty()) {
                this.failedTasks.forEach(this::submit);
                this.failedTasks.clear();
            }
        });
    }

    public synchronized void drain(class_1937 level) {
        AutoMergeQueue queue = this.allTasks.remove(level.method_27983());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        BlockUtils.performBatch(() -> {
            while (!queue.isEmpty()) {
                queue.pop().run(level);
            }
        });
    }

    public synchronized boolean isEmpty(class_5321<class_1937> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        return m == null || m.isEmpty();
    }

    @Nullable
    public synchronized IWorldUpdateTask poll(class_5321<class_1937> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        if (m != null && !m.isEmpty()) {
            return m.pop();
        }
        return null;
    }

    public static class AutoMergeQueue {
        private final HashMap<class_2338, IWorldUpdateTask> fastTable = new HashMap();
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public void push(IWorldUpdateTask task) {
            class_2338 blockPos = task.blockPos();
            IWorldUpdateTask pendingTask = this.fastTable.get(blockPos);
            if (pendingTask == null) {
                this.tasks.add(task);
                this.fastTable.put(blockPos, task);
                return;
            }
            if (pendingTask instanceof AutoMergeTask) {
                AutoMergeTask mergeTask = (AutoMergeTask)pendingTask;
                mergeTask.add(task);
                return;
            }
            AutoMergeTask mergedTask = new AutoMergeTask(pendingTask);
            mergedTask.add(task);
            this.fastTable.put(blockPos, mergedTask);
        }

        public IWorldUpdateTask pop() {
            IWorldUpdateTask task = this.tasks.remove(0);
            IWorldUpdateTask mergedTask = this.fastTable.remove(task.blockPos());
            if (mergedTask != null) {
                return mergedTask;
            }
            return task;
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }
    }

    public static class AutoMergeTask
    implements IWorldUpdateTask {
        private final class_1937 level;
        private final class_2338 blockPos;
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public AutoMergeTask(IWorldUpdateTask task) {
            this.level = task.level();
            this.blockPos = task.blockPos();
            this.tasks.add(task);
        }

        public void add(IWorldUpdateTask task) {
            this.tasks.add(task);
        }

        public void optimize(class_1937 level) {
            ArrayList<IWorldUpdateTask> optimizedTasks = new ArrayList<IWorldUpdateTask>();
            class_2680 lastBlockState = null;
            for (IWorldUpdateTask task : this.tasks) {
                class_2680 newBlockState = task.blockState();
                if (!Objects.equals(newBlockState, lastBlockState)) {
                    lastBlockState = newBlockState;
                    optimizedTasks.clear();
                }
                optimizedTasks.add(task);
            }
            if (this.tasks.size() != optimizedTasks.size()) {
                this.tasks.clear();
                this.tasks.addAll(optimizedTasks);
            }
        }

        @Override
        public class_1937 level() {
            return this.level;
        }

        @Override
        public class_2338 blockPos() {
            return this.blockPos;
        }

        @Override
        public class_2680 blockState() {
            return null;
        }

        @Override
        public class_1269 run(class_1937 level) {
            this.optimize(level);
            int changes = 0;
            ArrayList<IWorldUpdateTask> failedTasks = new ArrayList<IWorldUpdateTask>();
            for (IWorldUpdateTask task : this.tasks) {
                class_1269 resultType = task.run(level);
                if (resultType.method_23665()) {
                    ++changes;
                }
                if (resultType != class_1269.field_5814) continue;
                failedTasks.add(task);
            }
            if (!failedTasks.isEmpty()) {
                this.tasks.clear();
                this.tasks.addAll(failedTasks);
                return class_1269.field_5814;
            }
            if (changes != 0) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
    }
}

