/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CubeReplacingEvent {
    public final class_1799 source;
    public final class_2248 sourceBlock;
    public final BlockPaintColor sourceBlockColor;
    public final class_1799 destination;
    public final class_2248 destinationBlock;
    public final BlockPaintColor destinationBlockColor;
    public final boolean isEmptySource;
    public final boolean isEmptyDestination;
    public final boolean isChangedBlock;
    public boolean keepColor = true;
    public boolean keepPaintType = true;
    public int changes = 0;
    public int blockChanges = 0;
    public int blockColorChanges = 0;

    public CubeReplacingEvent(class_1799 source, class_1799 destination) {
        this.source = source;
        this.sourceBlock = this.getBlock(source);
        this.sourceBlockColor = this.getBlockColor(source);
        this.destination = destination;
        this.destinationBlock = this.getBlock(destination);
        this.destinationBlockColor = this.getBlockColor(destination);
        this.isEmptySource = this.sourceBlock == null && this.sourceBlockColor == null;
        this.isEmptyDestination = this.destinationBlock == null && this.destinationBlockColor == null;
        this.isChangedBlock = this.isChangedBlock();
    }

    public boolean accept(CubeWrapper cube) {
        if (!cube.is(IBlockPaintable.class)) {
            return false;
        }
        if (this.source.method_7960()) {
            return true;
        }
        if (this.sourceBlock != null && !cube.is(this.sourceBlock)) {
            return false;
        }
        if (this.sourceBlockColor != null) {
            int diff = 0;
            for (OpenDirection dir : OpenDirection.values()) {
                SkinPaintColor t;
                SkinPaintColor s = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
                if (Objects.equals(s, t = cube.getColor(dir))) continue;
                ++diff;
            }
            if (this.isChangedBlock) {
                return diff < 1;
            }
            return diff < 6;
        }
        return true;
    }

    public void apply(CubeWrapper cube) {
        if (!cube.is(IBlockPaintable.class)) {
            return;
        }
        int oldBlockChanges = this.blockChanges;
        int oldBlockColorChanges = this.blockColorChanges;
        if (!this.destination.method_7960() && this.destinationBlockColor != null) {
            this.applyColor(cube);
        }
        if (this.isChangedBlock) {
            this.applyBlock(cube);
        }
        if (oldBlockChanges != this.blockChanges || oldBlockColorChanges != this.blockColorChanges) {
            ++this.changes;
        }
    }

    private void applyColor(CubeWrapper cube) {
        if (this.keepColor && this.keepPaintType) {
            return;
        }
        HashMap<OpenDirection, SkinPaintColor> newColors = new HashMap<OpenDirection, SkinPaintColor>();
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor sourceColor;
            SkinPaintColor targetColor = cube.getColor(dir);
            if (this.sourceBlockColor != null && !Objects.equals(sourceColor = this.sourceBlockColor.getOrDefault(dir, SkinPaintColor.WHITE), targetColor)) {
                newColors.put(dir, targetColor);
                continue;
            }
            SkinPaintColor newColor = this.destinationBlockColor.getOrDefault(dir, SkinPaintColor.WHITE);
            int color = newColor.argb();
            if (this.keepColor) {
                color = targetColor.argb();
            }
            SkinPaintType paintType = newColor.paintType();
            if (this.keepPaintType) {
                paintType = targetColor.paintType();
            }
            newColor = SkinPaintColor.of(color, paintType);
            newColors.put(dir, newColor);
        }
        cube.setColors(newColors);
        ++this.blockColorChanges;
    }

    private void applyBlock(CubeWrapper cube) {
        if (!cube.is(SkinCubeBlock.class)) {
            return;
        }
        class_2487 newNBT = null;
        class_2680 oldState = cube.blockState();
        class_2680 newState = class_2246.field_10124.method_9564();
        if (this.destinationBlock != null) {
            newNBT = cube.blockTag();
            newState = this.destinationBlock.method_9564();
            for (class_2769 property : oldState.method_28501()) {
                newState = this.applyBlockState(newState, oldState, property);
            }
        }
        cube.setBlockStateAndTag(newState, newNBT);
        ++this.blockChanges;
    }

    private <T extends Comparable<T>> class_2680 applyBlockState(class_2680 newState, class_2680 oldState, class_2769<T> property) {
        if (newState.method_28498(property)) {
            return (class_2680)newState.method_11657(property, oldState.method_11654(property));
        }
        return newState;
    }

    private class_2248 getBlock(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.method_7711();
        }
        return null;
    }

    private BlockPaintColor getBlockColor(class_1799 itemStack) {
        IItemPaintable provider;
        SkinPaintColor paintColor;
        class_1792 item = itemStack.method_7909();
        if (item instanceof SkinCubeItem) {
            SkinCubeItem cubeItem = (SkinCubeItem)item;
            return cubeItem.getItemColors(itemStack);
        }
        if (item instanceof IItemPaintable && (paintColor = (provider = (IItemPaintable)item).getItemColor(itemStack)) != null) {
            return new BlockPaintColor(paintColor);
        }
        return null;
    }

    private boolean isChangedBlock() {
        if (this.source.method_7960() && this.destinationBlock != null) {
            return true;
        }
        if (this.destination.method_7960() && this.sourceBlock != null) {
            return true;
        }
        return this.destinationBlock != null && !this.destinationBlock.equals(this.sourceBlock);
    }
}

