/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.class_1269;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class CubeChanges
implements IUserAction,
IWorldUpdateTask {
    private final class_1937 level;
    private final class_2338 blockPos;
    private class_2680 blockState;
    private class_2487 nbt;
    private Map<OpenDirection, SkinPaintColor> colors;

    public CubeChanges(class_1937 level, class_2338 blockPos) {
        this.level = level;
        this.blockPos = blockPos;
    }

    public void setBlockState(class_2680 blockState) {
        this.blockState = blockState;
    }

    public void setCompoundTag(class_2487 nbt) {
        this.nbt = nbt;
    }

    public void setColor(OpenDirection dir, SkinPaintColor color) {
        if (this.colors == null) {
            this.colors = new HashMap<OpenDirection, SkinPaintColor>();
        }
        this.colors.put(dir, color);
    }

    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.colors = colors;
    }

    @Override
    public class_2338 blockPos() {
        return this.blockPos;
    }

    @Override
    public class_2680 blockState() {
        return this.blockState;
    }

    private boolean isChangeNBT() {
        return this.nbt != null || this.colors != null;
    }

    @Override
    public void prepare() throws RuntimeException {
        if (!this.isChangeNBT()) {
            return;
        }
        if (this.blockState != null) {
            return;
        }
        class_2586 blockEntity = this.level.method_8321(this.blockPos);
        if (blockEntity == null) {
            String value = String.format("x=%d, y=%d, z=%d", this.blockPos.method_10263(), this.blockPos.method_10264(), this.blockPos.method_10260());
            throw new ActionRuntimeException((class_2561)class_2561.method_43469((String)"chat.armourers_workshop.undo.missingBlock", (Object[])new Object[]{value}));
        }
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        class_2586 blockEntity2;
        boolean isChangedNBT = false;
        CubeChanges changes = new CubeChanges(this.level, this.blockPos);
        if (this.blockState != null) {
            changes.setBlockState(this.level.method_8320(this.blockPos));
            isChangedNBT = true;
        }
        if (this.nbt != null) {
            isChangedNBT = true;
        }
        if (isChangedNBT) {
            Objects.flatMap(this.level.method_8321(this.blockPos), blockEntity -> {
                class_2487 newTag = StorageAPI.saveFullData(blockEntity, this.level.method_30349());
                changes.setCompoundTag(newTag);
                return newTag;
            });
        } else if (this.colors != null && (blockEntity2 = this.level.method_8321(this.blockPos)) instanceof IBlockPaintable) {
            IBlockPaintable target = (IBlockPaintable)blockEntity2;
            HashMap<OpenDirection, SkinPaintColor> oldValue = new HashMap<OpenDirection, SkinPaintColor>();
            for (OpenDirection direction : this.colors.keySet()) {
                SkinPaintColor paintColor = target.getColor(direction);
                if (paintColor == null) {
                    paintColor = SkinPaintColor.CLEAR;
                }
                oldValue.put(direction, paintColor);
            }
            changes.setColors(oldValue);
        }
        WorldUpdater.getInstance().submit(this);
        return changes;
    }

    @Override
    public class_1937 level() {
        return this.level;
    }

    @Override
    public class_1269 run(class_1937 level) {
        if (!level.method_8477(this.blockPos)) {
            return class_1269.field_5811;
        }
        int changes = 0;
        if (this.blockState != null && !this.blockState.equals(level.method_8320(this.blockPos))) {
            level.method_8652(this.blockPos, this.blockState, 3);
            ++changes;
        }
        class_2586 blockEntity = null;
        if (this.isChangeNBT()) {
            blockEntity = level.method_8321(this.blockPos);
        }
        if (this.nbt != null && blockEntity != null) {
            StorageAPI.loadFullData(blockEntity, this.nbt, level.method_30349());
            ++changes;
        }
        if (this.colors != null && blockEntity instanceof IBlockPaintable) {
            IBlockPaintable paintable = (IBlockPaintable)blockEntity;
            paintable.setColors(this.colors);
            ++changes;
        }
        if (changes == 0) {
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }
}

