/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IBlockSnapshot;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.NamedUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.SetBlockAction;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.event.common.BlockEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public final class BlockUtils {
    private static final Set<IRegistryHolder<class_2248>> SNAPSHOT_BLOCKS = Collections.immutableSet(it -> {
        it.add(ModBlocks.SKIN_CUBE);
        it.add(ModBlocks.SKIN_CUBE_GLASS);
        it.add(ModBlocks.SKIN_CUBE_GLASS_GLOWING);
        it.add(ModBlocks.SKIN_CUBE_GLOWING);
        it.add(ModBlocks.ADVANCED_SKIN_BUILDER);
    });
    private static final ThreadLocal<Map<class_2586, Runnable>> SNAPSHOT_QUEUE = ThreadLocal.withInitial(() -> null);

    public static void beginCombiner() {
        Map<class_2586, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            SNAPSHOT_QUEUE.set(new IdentityHashMap());
        }
    }

    public static <T extends class_2586> void combine(T blockEntity, Runnable handler) {
        Map<class_2586, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            handler.run();
            blockEntity.method_5431();
            return;
        }
        queue.put(blockEntity, handler);
    }

    public static void snapshot(BlockEvent event) {
        class_3222 player;
        class_1297 class_12972;
        block5: {
            block4: {
                class_12972 = event.entity();
                if (!(class_12972 instanceof class_3222)) break block4;
                player = (class_3222)class_12972;
                class_12972 = event.level();
                if (class_12972 instanceof class_1937) break block5;
            }
            return;
        }
        class_1937 level = (class_1937)class_12972;
        ActionType actionType = ActionType.of(event);
        if (actionType == null) {
            return;
        }
        IBlockSnapshot snapshot = event.snapshot();
        NamedUserAction group = new NamedUserAction(actionType.title());
        group.push(new SetBlockAction(level, event.blockPos(), snapshot.state(), snapshot.tag()));
        UndoManager.of(player.method_5667()).push(group);
    }

    public static void endCombiner() {
        Map<class_2586, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            return;
        }
        queue.forEach((k, v) -> {
            v.run();
            k.method_5431();
        });
        SNAPSHOT_QUEUE.remove();
    }

    public static void performBatch(Runnable handler) {
        try {
            BlockUtils.beginCombiner();
            handler.run();
        }
        finally {
            BlockUtils.endCombiner();
        }
    }

    public static ArrayList<class_2338> findTouchingBlockFaces(class_1937 level, class_2338 pos, OpenDirection facing, int radius, boolean restrictPlane) {
        ArrayList<class_2338> blockFaces = new ArrayList<class_2338>();
        ArrayList<class_2338> openList = new ArrayList<class_2338>();
        HashSet<class_2338> closedList = new HashSet<class_2338>();
        class_2338 startPos = pos.method_10093(AbstractDirection.unwrap(facing));
        openList.add(startPos);
        OpenDirection[] sides = OpenDirection.values();
        boolean first = true;
        while (!openList.isEmpty()) {
            class_2338 loc = (class_2338)openList.remove(0);
            class_2586 blockEntity = level.method_8321(loc);
            if (blockEntity instanceof IBlockPaintable) {
                if (!restrictPlane) {
                    blockFaces.add(loc);
                } else if (BlockUtils.samePlane(loc, pos, facing)) {
                    blockFaces.add(loc);
                }
            }
            for (OpenDirection side : sides) {
                class_2338 sideLoc = loc.method_10093(AbstractDirection.unwrap(side));
                if (closedList.contains(sideLoc)) continue;
                closedList.add(sideLoc);
                if (!(BlockUtils.getDistance(sideLoc, pos) < (double)radius & BlockUtils.hasPaintableBlock(level, sideLoc))) continue;
                openList.add(sideLoc);
            }
            if (closedList.size() <= 5000) continue;
            break;
        }
        return blockFaces;
    }

    public static double getDistance(class_2338 src, class_2338 dst) {
        double d0 = src.method_10263() - dst.method_10263();
        double d1 = src.method_10264() - dst.method_10264();
        double d2 = src.method_10260() - dst.method_10260();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    private static boolean hasPaintableBlock(class_1937 level, class_2338 pos) {
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    class_2586 stateValid = level.method_8321(pos.method_10069(ix - 1, iy - 1, iz - 1));
                    if (!(stateValid instanceof IBlockPaintable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean samePlane(class_2338 src, class_2338 dst, OpenDirection direction) {
        if (!(direction.stepX() != 0 && src.method_10263() != dst.method_10263() || direction.stepY() != 0 && src.method_10264() != dst.method_10264())) {
            return direction.stepZ() == 0 || src.method_10260() == dst.method_10260();
        }
        return false;
    }

    private static boolean isSnapshotBlock(class_2248 block) {
        return SNAPSHOT_BLOCKS.stream().anyMatch(it -> it.get() == block);
    }

    public static class ActionType {
        private final class_2561 title;

        private ActionType(class_2561 title) {
            this.title = title;
        }

        public static ActionType of(BlockEvent event) {
            class_2680 blockState = event.blockState();
            if (blockState != null && BlockUtils.isSnapshotBlock(blockState.method_26204())) {
                return new ActionType((class_2561)class_2561.method_43471((String)"chat.armourers_workshop.undo.placeBlock"));
            }
            IBlockSnapshot snapshot = event.snapshot();
            if (blockState == null && BlockUtils.isSnapshotBlock(snapshot.state().method_26204())) {
                return new ActionType((class_2561)class_2561.method_43471((String)"chat.armourers_workshop.undo.breakBlock"));
            }
            return null;
        }

        public class_2561 title() {
            return this.title;
        }
    }
}

