/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public class ArmourerMenu
extends AbstractBlockEntityMenu<ArmourerBlockEntity> {
    private final class_1277 inventory = new class_1277(4);
    private Group group = null;

    public ArmourerMenu(class_3917<?> menuType, class_2248 block, int containerId, class_1661 playerInventory, IGlobalPos access) {
        super((class_3917)menuType, block, containerId, access);
        this.addPlayerSlots((class_1263)playerInventory, 8, 142, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addCustomSlot((class_1263)this.inventory, 0, 64, 21);
        this.addCustomSlot((class_1263)this.inventory, 1, 147, 21);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, (class_1263)this.inventory);
    }

    public boolean shouldLoadArmourItem(class_1657 player) {
        class_1799 stackInput = this.inventory.method_5438(0);
        class_1799 stackOutput = this.inventory.method_5438(1);
        if (stackInput.method_7960() || !stackOutput.method_7960()) {
            return false;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        return !descriptor.isEmpty();
    }

    public boolean shouldSaveArmourItem(class_1657 player) {
        class_1799 stackInput = this.inventory.method_5438(0);
        class_1799 stackOutput = this.inventory.method_5438(1);
        if (player.method_7337() && stackInput.method_7960()) {
            stackInput = new class_1799((class_1935)ModItems.SKIN_TEMPLATE.get());
        }
        return !stackInput.method_7960() && stackOutput.method_7960();
    }

    public void saveArmourItem(class_1657 player, GameProfile profile, String customName, String tags) {
        if (!this.shouldSaveArmourItem(player)) {
            return;
        }
        if (((ArmourerBlockEntity)this.blockEntity).method_10997() == null || ((ArmourerBlockEntity)this.blockEntity).method_10997().method_8608()) {
            return;
        }
        try {
            class_1799 stackInput = this.inventory.method_5438(0);
            SkinProperties skinProps = ((ArmourerBlockEntity)this.blockEntity).skinProperties().copy();
            skinProps.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProps.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            if (customName != null) {
                skinProps.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            }
            class_1937 level = ((ArmourerBlockEntity)this.blockEntity).method_10997();
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            Skin skin = WorldUtils.saveSkinFromWorld(level, transform, skinProps, ((ArmourerBlockEntity)this.blockEntity).skinType(), ((ArmourerBlockEntity)this.blockEntity).paintData());
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
            if (!player.method_7337()) {
                stackInput.method_7934(1);
            }
            this.inventory.method_5447(1, descriptor.asItemStack());
        }
        catch (TranslatableException exception) {
            player.method_43496(exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadArmourItem(class_1657 player) {
        if (((ArmourerBlockEntity)this.blockEntity).method_10997() == null || ((ArmourerBlockEntity)this.blockEntity).method_10997().method_8608()) {
            return;
        }
        class_1799 stackInput = this.inventory.method_5438(0);
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        if (!this.shouldLoadArmourItem(player)) {
            return;
        }
        try {
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.identifier());
            if (skin == null) {
                throw SkinLoadException.Type.NOT_FOUND.build("notFound", new Object[0]);
            }
            if (skin.type() != ((ArmourerBlockEntity)this.blockEntity).skinType()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_TYPE.build("notSupportType", new Object[0]);
            }
            if (!skin.isBasicOnly()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_CONTENT.build("notSupportContent", new Object[0]);
            }
            if (!skin.settings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            ((ArmourerBlockEntity)this.blockEntity).setSkinProperties(skin.properties());
            ((ArmourerBlockEntity)this.blockEntity).setPaintData(skin.paintData());
            CubeChangesCollector collector = new CubeChangesCollector(((ArmourerBlockEntity)this.blockEntity).method_10997());
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            WorldUtils.loadSkinIntoWorld(collector, transform, skin);
            collector.submit((class_2561)class_2561.method_43471((String)"action.armourers_workshop.block.load"), player);
            this.inventory.method_5447(0, class_1799.field_8037);
            this.inventory.method_5447(1, stackInput);
        }
        catch (TranslatableException exception) {
            player.method_43496(exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        return this.quickMoveStack(player, index, this.field_7761.size() - 1);
    }

    protected void addCustomSlot(class_1263 inventory, final int slot, int x, int y) {
        this.method_7621(new GroupSlot(this, inventory, slot, x, y){

            public boolean method_7680(class_1799 itemStack) {
                if (slot == 0) {
                    if (itemStack.method_31574((class_1792)ModItems.SKIN_TEMPLATE.get())) {
                        return true;
                    }
                    return !SkinDescriptor.of(itemStack).isEmpty();
                }
                return false;
            }
        });
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public boolean shouldRenderInventory() {
        return this.group == Group.MAIN;
    }

    public static enum Group {
        MAIN,
        SKIN,
        DISPLAY,
        BLOCK;

    }

    public class GroupSlot
    extends class_1735 {
        public GroupSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7682() {
            return ArmourerMenu.this.shouldRenderInventory();
        }
    }
}

