/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModSounds;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3414;

public class BlendingToolItem
extends AbstractColoredToolItem
implements IBlockPaintViewer {
    public BlendingToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.INTENSITY);
        builder.accept(PaintingToolOptions.RADIUS_SAMPLE);
        builder.accept(PaintingToolOptions.RADIUS_EFFECT);
        builder.accept(PaintingToolOptions.PLANE_RESTRICT);
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
    }

    protected CubeSelector createColorApplierSelector(int radius, class_1838 context) {
        class_1799 itemStack = context.method_8041();
        Boolean restrictPlane = ToolAPI.get(itemStack, PaintingToolOptions.PLANE_RESTRICT);
        boolean isFullMode = this.shouldUseFullMode(context);
        return CubeSelector.touching(context.method_8037(), radius, isFullMode, restrictPlane);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(class_2586 blockEntity, class_1838 context) {
        if (blockEntity instanceof ArmourerBlockEntity) {
            return null;
        }
        return super.createPaintToolSelector(blockEntity, context);
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        Integer radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        return this.createColorApplierSelector(radiusEffect, context);
    }

    @Override
    public IPaintToolAction createPaintToolAction(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        Integer intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        Integer radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        CubeChangesCollector collector = new CubeChangesCollector(context.method_8045());
        this.createColorApplierSelector(radiusSample, context).forEach(context, (targetPos, dir) -> {
            SkinPaintColor paintColor;
            CubeWrapper cube = collector.cubeAtPos((class_2338)targetPos);
            if (cube.shouldChangeColor((OpenDirection)dir) && (paintColor = cube.getColor((OpenDirection)dir)) != null) {
                colors.add(paintColor.argb());
            }
        });
        SkinPaintColor paintColor = SkinPaintColor.of(ColorUtils.getAverageColor(colors), SkinPaintTypes.NORMAL);
        return new CubePaintingEvent.BlendingAction(paintColor, intensity);
    }

    @Override
    public void appendSettingHoverText(class_1799 itemStack, List<class_2561> tooltips) {
        int intensity = ToolAPI.get(itemStack, PaintingToolOptions.INTENSITY);
        int radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        int radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.intensity", intensity));
        tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.sampleRadius", radiusSample, radiusSample, 1));
        tooltips.add((class_2561)TranslateUtils.subtitle("item.armourers_workshop.rollover.effectRadius", radiusEffect, radiusEffect, 1));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public IRegistryHolder<class_3414> getItemSoundEvent(class_1838 context) {
        return ModSounds.PAINT;
    }
}

