/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSIndexPath;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UIPassthroughView;
import com.apple.library.uikit.UITableView;
import com.apple.library.uikit.UITableViewCell;
import com.apple.library.uikit.UITableViewDataSource;
import com.apple.library.uikit.UITableViewDelegate;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.builder.client.gui.widget.NewComboItem;
import moe.plushie.armourers_workshop.init.ModTextures;
import org.jetbrains.annotations.Nullable;

public class NewComboBox
extends UIControl
implements UITableViewDataSource,
UITableViewDelegate {
    protected final UIButton titleView = new UIButton(CGRect.ZERO);
    protected final UIView popoverView = new UIView(CGRect.ZERO);
    protected final UIImageView popoverBackgroundView = new UIImageView(CGRect.ZERO);
    protected final UITableView popoverContentView = new UITableView(CGRect.ZERO);
    protected final UIPassthroughView passthroughView = new UIPassthroughView(this.popoverView);
    protected final ArrayList<NewComboItem> sections = new ArrayList();
    protected NSIndexPath selectedIndex = new NSIndexPath(0, 0);
    protected int maxRows = 0;

    public NewComboBox(CGRect frame) {
        super(frame);
        this.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 20.0f).clip(4.0f, 4.0f, 0.0f, 4.0f).build());
        this.popoverView.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(0.0f, 0.0f).resizable(24.0f, 24.0f).build());
        this.titleView.setUserInteractionEnabled(false);
        this.titleView.setHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
        this.titleView.setContentEdgeInsets(new UIEdgeInsets(0.0f, 4.0f, 0.0f, 4.0f));
        this.titleView.setTitleEdgeInsets(new UIEdgeInsets(0.0f, 4.0f, 0.0f, 0.0f));
        this.titleView.setTitleColor(UIColor.WHITE, 0);
        this.titleView.setTitleColor(UIColor.of(-96), 1);
        this.titleView.setTitleColor(UIColor.of(-3407872), 4);
        this.titleView.setCanBecomeFocused(false);
        this.titleView.setAutoresizingMask(18);
        this.addSubview(this.titleView);
        this.popoverContentView.setRowHeight(16);
        this.popoverContentView.setDataSource(this);
        this.popoverContentView.setDelegate(this);
        this.popoverBackgroundView.setImage(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(96.0f, 0.0f).resizable(24.0f, 24.0f).build());
        this.popoverBackgroundView.setAutoresizingMask(18);
        this.popoverView.addSubview(this.popoverBackgroundView);
        this.popoverView.setZIndex(400);
        this.popoverView.addSubview(this.popoverContentView);
        this.popoverView.setOpaque(false);
    }

    public void reloadData(List<? extends NewComboItem> items) {
        this.sections.clear();
        this.sections.addAll(items);
        this.applyTableViewSize();
        this.popoverContentView.reloadData();
        this.layoutIfNeeded();
        this.updateTitleView(this.selectedIndex);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        SoundManagerImpl.click();
        this.setSelected(!this.isSelected());
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        float h = rect.height;
        this.titleView.setFrame(rect.insetBy(1.0f, 1.0f, 1.0f, h + 1.0f));
        this.applyTableViewSize();
    }

    @Override
    public void didMoveToWindow() {
        super.didMoveToWindow();
        this.updatePassthroughView();
    }

    @Override
    public int tableViewNumberOfSections(UITableView tableView) {
        return this.sections.size();
    }

    @Override
    public int tableViewNumberOfRowsInSection(UITableView tableView, int section) {
        return this.sections.get(section).size();
    }

    @Override
    public UITableViewCell tableViewCellForRow(UITableView tableView, NSIndexPath indexPath) {
        NewComboItem section = this.sections.get(indexPath.section);
        Cell cell = new Cell();
        this.updateEntryView(cell, section.get(indexPath.row), section);
        return cell;
    }

    @Override
    public UIView tableViewViewForHeaderInSection(UITableView tableView, int section) {
        NewComboItem sec = this.sections.get(section);
        UIButton view = new UIButton(CGRect.ZERO);
        view.setTitle(sec.title(), 0);
        view.setTitleColor(UIColor.WHITE, 0);
        view.setHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
        view.setContentEdgeInsets(new UIEdgeInsets(0.0f, 4.0f, 0.0f, 4.0f));
        return view;
    }

    @Override
    public float tableViewHeightForHeaderInSection(UITableView tableView, int section) {
        return tableView.rowHeight() + 4;
    }

    @Override
    public void tableViewDidSelectRow(UITableView tableView, NSIndexPath indexPath) {
        this.setSelectedIndex(indexPath);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    @Override
    public void setSelected(boolean isSelected) {
        super.setSelected(isSelected);
        this.popoverView.removeFromSuperview();
        if (isSelected) {
            this.popoverContentView.setContentOffset(CGPoint.ZERO);
            this.addSubview(this.popoverView);
        }
        if (isSelected) {
            this.addGlobalClickListener();
        } else {
            this.removeGlobalClickListener();
        }
        this.updatePassthroughView();
    }

    public NSIndexPath selectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(NSIndexPath selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.updateTitleView(selectedIndex);
    }

    public int maxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    protected void updateTitleView(NSIndexPath indexPath) {
        if (indexPath.section < 0 || indexPath.section >= this.sections.size()) {
            return;
        }
        NewComboItem section = this.sections.get(indexPath.section);
        if (indexPath.row < 0 || indexPath.row >= section.size()) {
            return;
        }
        UIComboItem item = section.get(indexPath.row);
        NSMutableString name = new NSMutableString(section.title());
        name.append(" - ");
        name.append(item.title);
        this.titleView.setTitle(name, 7);
        this.titleView.setImage(item.image, 7);
    }

    protected void updateEntryView(Cell entry, UIComboItem item, NewComboItem section) {
        entry.setup(item);
    }

    @Override
    protected boolean shouldBeHighlight(CGPoint point, UIEvent event) {
        return this.bounds().contains(point);
    }

    @Override
    protected boolean shouldPassHighlighted() {
        return false;
    }

    private void applyTableViewSize() {
        CGRect rect = this.bounds();
        float popoverHeight = 0.0f;
        if (this.maxRows != 0) {
            popoverHeight = this.maxRows * this.popoverContentView.rowHeight();
        }
        if (popoverHeight == 0.0f) {
            UIEdgeInsets edg = this.popoverContentView.contentInsets();
            popoverHeight = edg.top + this.popoverContentView.contentSize().height + edg.bottom;
        }
        this.popoverView.setFrame(new CGRect(0.0f, rect.height, rect.width, popoverHeight));
        this.popoverBackgroundView.setFrame(this.popoverView.bounds());
        this.popoverContentView.setFrame(this.popoverView.bounds());
    }

    private void addGlobalClickListener() {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        window.addGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, event) -> {
            if (self.isOutsideEvent((UIEvent)event)) {
                self.setSelected(false);
                self.removeGlobalClickListener();
            }
        });
    }

    private void removeGlobalClickListener() {
        UIWindow window = this.window();
        if (window == null) {
            return;
        }
        window.removeGlobalTarget(this, UIControl.Event.MOUSE_LEFT_DOWN);
    }

    private void updatePassthroughView() {
        UIWindow window = this.window();
        if (window != null && this.popoverView.superview() != null) {
            if (this.passthroughView.superview() != window) {
                window.addSubview(this.passthroughView);
            }
        } else if (this.passthroughView.superview() != null) {
            this.passthroughView.removeFromSuperview();
        }
    }

    private boolean isOutsideEvent(UIEvent event) {
        if (this.pointInside(event.locationInView(this), event)) {
            return false;
        }
        return !this.popoverView.pointInside(event.locationInView(this.popoverView), event);
    }

    public static class Cell
    extends UITableViewCell {
        private static final UIColor BACKGROUND_COLOR = UIColor.of(0x44CCCCCC);
        public final UIButton titleView = new UIButton(CGRect.ZERO);

        public Cell() {
            super(CGRect.ZERO);
            this.titleView.setUserInteractionEnabled(false);
            this.titleView.setHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
            this.titleView.setContentEdgeInsets(new UIEdgeInsets(0.0f, 8.0f, 0.0f, 4.0f));
            this.titleView.setTitleEdgeInsets(new UIEdgeInsets(0.0f, 4.0f, 0.0f, 0.0f));
            this.titleView.setTitleColor(UIColor.WHITE, 0);
            this.titleView.setTitleColor(UIColor.of(-96), 1);
            this.titleView.setTitleColor(UIColor.of(-3407872), 4);
            this.titleView.setCanBecomeFocused(false);
            this.titleView.setAutoresizingMask(18);
            this.addSubview(this.titleView);
        }

        public void setup(@Nullable UIComboItem item) {
            if (item == null) {
                this.setHidden(true);
                return;
            }
            this.titleView.setTitle(item.title, 7);
            this.titleView.setImage(item.image, 7);
            this.titleView.setEnabled(item.isEnabled);
            this.setHidden(false);
        }

        @Override
        public void setHighlighted(boolean highlighted) {
            super.setHighlighted(highlighted);
            this.titleView.setHighlighted(highlighted);
            if (highlighted) {
                this.setBackgroundColor(BACKGROUND_COLOR);
            } else {
                this.setBackgroundColor(null);
            }
        }
    }
}

