/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Inventory.CarriedProvider;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.PlayerInventoryView;
import moe.plushie.armourers_workshop.core.client.gui.widget.SlotListView;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ArmourerReplaceDialog
extends ConfirmDialog {
    private final class_1661 playerInventory;
    private final class_1263 inventory;
    private final UICheckBox keepPaintBox = new UICheckBox(CGRect.ZERO);
    private final UICheckBox keepColorBox = new UICheckBox(CGRect.ZERO);
    private final SlotListView<PickerContainer> listView;
    private final PlayerInventoryView inventoryView = new PlayerInventoryView(new CGRect(0.0f, 0.0f, 176.0f, 98.0f));

    public ArmourerReplaceDialog() {
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 130.0f));
        class_1657 player = EnvironmentManager.getPlayer();
        this.playerInventory = player.method_31548();
        this.inventory = this.createBackup(this.playerInventory);
        this.listView = new SlotListView<PickerContainer>(new PickerContainer(this.inventory), this.playerInventory, this.bounds());
        this.setup();
    }

    private void setup() {
        this.layoutIfNeeded();
        float left = this.confirmButton.frame().x() + 1.0f;
        float centerX = this.cancelButton.frame().x() + 1.0f;
        float bottom = this.confirmButton.frame().y() - 4.0f;
        float width = this.bounds().width - 30.0f;
        float height = this.bounds().height() + 10.0f + 98.0f;
        this.setupBackgroundView(left, centerX, height);
        this.keepColorBox.setFrame(new CGRect(left, bottom - 22.0f, width, 9.0f));
        this.keepColorBox.setTitle(NSString.localizedString("armourer.dialog.replace.keepColor", new Object[0]));
        this.keepColorBox.setSelected(false);
        this.addSubview(this.keepColorBox);
        this.keepPaintBox.setFrame(new CGRect(left, bottom - 11.0f, width, 9.0f));
        this.keepPaintBox.setTitle(NSString.localizedString("armourer.dialog.replace.keepPaint", new Object[0]));
        this.keepPaintBox.setSelected(false);
        this.addSubview(this.keepPaintBox);
        this.bringSubviewToFront(this.confirmButton);
        this.bringSubviewToFront(this.cancelButton);
        this.listView.setFrame(new CGRect(0.0f, 0.0f, this.bounds().width(), height));
        this.listView.menu().reloadSlots(this.inventoryView.frame(), new CGRect(left + 32.0f, 44.0f, 0.0f, 0.0f));
        this.addSubview(this.listView);
    }

    private void setupBackgroundView(float left, float center, float height) {
        UILabel label1 = new UILabel(new CGRect(left + 8.0f, 25.0f, 100.0f, 9.0f));
        UILabel label2 = new UILabel(new CGRect(center + 8.0f, 25.0f, 100.0f, 9.0f));
        label1.setText(NSString.localizedString("armourer.dialog.replace.srcBlock", new Object[0]));
        label2.setText(NSString.localizedString("armourer.dialog.replace.desBlock", new Object[0]));
        this.addSubview(label1);
        this.addSubview(label2);
        float placeholderX = left + 32.0f;
        float placeholderY = 44.0f;
        UIImageView slot1 = new UIImageView(new CGRect(placeholderX - 5.0f, placeholderY - 5.0f, 26.0f, 26.0f));
        UIImageView slot2 = new UIImageView(new CGRect(placeholderX - 5.0f + 110.0f, placeholderY - 5.0f, 26.0f, 26.0f));
        slot1.setImage(UIImage.of(ModTextures.ARMOURER).uv(230.0f, 18.0f).build());
        slot2.setImage(UIImage.of(ModTextures.ARMOURER).uv(230.0f, 18.0f).build());
        this.addSubview(slot1);
        this.addSubview(slot2);
        this.inventoryView.setFrame(new CGRect(32.0f, height - 98.0f, 176.0f, 98.0f));
        this.inventoryView.setName(new NSString(this.playerInventory.method_5476()));
        this.inventoryView.setStyle(PlayerInventoryView.Style.NORMAL);
        this.inventoryView.setUserInteractionEnabled(false);
        this.addSubview(this.inventoryView);
        this.addHelpButton(left, 25.0f, "armourer.dialog.replace.help.selector");
        this.addHelpButton(center, 25.0f, "armourer.dialog.replace.help.applier");
    }

    private class_1263 createBackup(class_1661 inventory) {
        int size = inventory.method_5439();
        class_1277 newInventory = new class_1277(size + 2);
        for (int i = 0; i < size; ++i) {
            newInventory.method_5447(i, inventory.method_5438(i).method_7972());
        }
        return newInventory;
    }

    public boolean isKeepColor() {
        return this.keepColorBox.isSelected();
    }

    public boolean isKeepPaintType() {
        return this.keepPaintBox.isSelected();
    }

    public class_1799 selector() {
        return this.inventory.method_5438(this.inventory.method_5439() - 2);
    }

    public class_1799 applier() {
        return this.inventory.method_5438(this.inventory.method_5439() - 1);
    }

    @Override
    public boolean pointInside(CGPoint point, UIEvent event) {
        if (super.pointInside(point, event)) {
            return true;
        }
        return this.subviews().stream().anyMatch(subview -> subview.pointInside(this.convertPointToView(point, (UIView)subview), event));
    }

    @Override
    @Nullable
    public UIView hitTest(CGPoint point, UIEvent event) {
        if (this._ignoresTouchEvents(this)) {
            return null;
        }
        if (!this.pointInside(point, event)) {
            return null;
        }
        for (UIView subview : this._invertedSubviews()) {
            UIView hitView;
            if (subview == this.listView || (hitView = subview.hitTest(this.convertPointToView(point, subview), event)) == null) continue;
            return hitView;
        }
        UIView hitView = this.listView.hitTest(this.convertPointToView(point, this.listView), event);
        if (hitView != null) {
            return hitView;
        }
        return this;
    }

    @Override
    public void setCenter(CGPoint newValue) {
        int extendHeight = 108;
        super.setCenter(new CGPoint(newValue.x, newValue.y - (float)extendHeight / 2.0f));
        if (this.listView != null) {
            this.listView.setNeedsLayout();
        }
    }

    private void addHelpButton(float x, float y, String tooltipKey) {
        UIButton button = new UIButton(new CGRect(x, y, 7.0f, 8.0f));
        button.setBackgroundImage(ModTextures.helpButtonImage(), 7);
        button.setTooltip(NSString.localizedString(tooltipKey, new Object[0]));
        button.setCanBecomeFocused(false);
        this.addSubview(button);
    }

    static class PickerContainer
    extends AbstractContainerMenu {
        class_1263 inventory;

        protected PickerContainer(class_1263 inventory) {
            super(null, 0);
            this.inventory = inventory;
        }

        public void method_7595(class_1657 player) {
            super.method_7595(player);
            CarriedProvider.setCarried(player.method_31548(), class_1799.field_8037);
        }

        public boolean method_7597(class_1657 p_75145_1_) {
            return true;
        }

        @Override
        public class_1799 method_7601(class_1657 player, int index) {
            return this.quickMoveStack(player, index, this.field_7761.size());
        }

        protected void reloadSlots(CGRect inventoryRect, CGRect placeholderRect) {
            this.field_7761.clear();
            this.addPlayerSlots(this.inventory, (int)inventoryRect.x + 8, (int)inventoryRect.y + 16);
            this.addPlaceholderSlots(this.inventory, this.inventory.method_5439() - 2, (int)placeholderRect.x, (int)placeholderRect.y);
        }

        protected void addPlaceholderSlots(class_1263 inventory, int offset, int placeholderX, int placeholderY) {
            for (int i = 0; i < 2; ++i) {
                this.method_7621(new class_1735(this, inventory, offset + i, placeholderX + i * 110, placeholderY){

                    public boolean method_7680(class_1799 itemStack) {
                        return itemStack.method_7909() instanceof IItemPaintable;
                    }
                });
            }
        }
    }
}

