/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerClearDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerCopyDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerReplaceDialog;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class ArmourerBlockSetting
extends ArmourerBaseSetting {
    protected final ArmourerBlockEntity blockEntity;

    protected ArmourerBlockSetting(ArmourerMenu container) {
        super("armourer.blockUtils");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        UIButton clearBtn = new UIButton(new CGRect(10.0f, 20.0f, 70.0f, 20.0f));
        clearBtn.setTitle(this.getDisplayText("clear", new Object[0]), 7);
        clearBtn.setTitleColor(UIColor.WHITE, 7);
        clearBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        clearBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::clearAction);
        this.addSubview(clearBtn);
        UIButton copyBtn = new UIButton(new CGRect(10.0f, 45.0f, 70.0f, 20.0f));
        copyBtn.setTitle(this.getDisplayText("copy", new Object[0]), 7);
        copyBtn.setTitleColor(UIColor.WHITE, 7);
        copyBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        copyBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::copyAction);
        this.addSubview(copyBtn);
        UIButton replaceBtn = new UIButton(new CGRect(10.0f, 70.0f, 70.0f, 20.0f));
        replaceBtn.setTitle(this.getDisplayText("replace", new Object[0]), 7);
        replaceBtn.setTitleColor(UIColor.WHITE, 7);
        replaceBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        replaceBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::replaceAction);
        this.addSubview(replaceBtn);
    }

    private void clearAction(UIControl sender) {
        ArmourerClearDialog dialog = new ArmourerClearDialog(this.getPartTypes(true));
        dialog.setTitle(NSString.localizedString("armourer.dialog.clear.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10556("Cubes", dialog.isClearBlocks());
            nbt.method_10556("Paints", dialog.isClearPaints());
            nbt.method_10556("Markers", dialog.isClearMarkers());
            nbt.method_10582("PartType", dialog.selectedPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_CLEAR.buildPacket(this.blockEntity, nbt));
        });
    }

    private void copyAction(UIControl sender) {
        ArmourerCopyDialog dialog = new ArmourerCopyDialog(this.getPartTypes(false));
        dialog.setTitle(NSString.localizedString("armourer.dialog.copy.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10556("Mirror", dialog.isMirror());
            nbt.method_10556("Paints", dialog.isCopyPaintData());
            nbt.method_10582("Source", dialog.sourcePartType().registryName().toString());
            nbt.method_10582("Destination", dialog.destinationPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_COPY.buildPacket(this.blockEntity, nbt));
        });
    }

    private void replaceAction(UIControl sender) {
        ArmourerReplaceDialog dialog = new ArmourerReplaceDialog();
        dialog.setTitle(NSString.localizedString("armourer.dialog.replace.title", new Object[0]));
        dialog.showInView(this, () -> {
            class_638 level = class_310.method_1551().field_1687;
            if (dialog.isCancelled() || level == null) {
                return;
            }
            class_2487 source = new class_2487();
            class_1799 selector = dialog.selector();
            if (selector.method_7909() instanceof IItemPaintable) {
                selector.method_57376((class_7225.class_7874)level.method_30349(), (class_2520)source);
            }
            class_2487 destination = new class_2487();
            class_1799 applier = dialog.applier();
            if (applier.method_7909() instanceof IItemPaintable) {
                applier.method_57376((class_7225.class_7874)level.method_30349(), (class_2520)destination);
            }
            if (source.method_33133() && destination.method_33133()) {
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10566("Source", (class_2520)source);
            nbt.method_10566("Destination", (class_2520)destination);
            nbt.method_10556("KeepColor", dialog.isKeepColor());
            nbt.method_10556("KeepPaintType", dialog.isKeepPaintType());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_REPLACE.buildPacket(this.blockEntity, nbt));
        });
    }

    public ArrayList<SkinPartType> getPartTypes(boolean usesAll) {
        SkinType skinType = this.blockEntity.skinType();
        SkinProperties skinProperties = this.blockEntity.skinProperties();
        ArrayList<SkinPartType> partTypes = new ArrayList<SkinPartType>();
        if (usesAll) {
            partTypes.add(0, SkinPartTypes.UNKNOWN);
        }
        if (skinType != SkinTypes.BLOCK) {
            partTypes.addAll(skinType.parts());
        } else if (skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
            partTypes.add(SkinPartTypes.BLOCK_MULTI);
        } else {
            partTypes.add(SkinPartTypes.BLOCK);
        }
        return partTypes;
    }
}

