/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIBarItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIMenuController;
import com.apple.library.uikit.UIMenuItem;
import com.apple.library.uikit.UIView;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentMinimapView;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentTypeListView;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedBonePanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedGeneralPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedSettingPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.DrawerToolbar;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeViewDelegate;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.class_2487;

public class AdvancedRightCardPanel
extends UIView
implements TreeViewDelegate {
    private final DocumentMinimapView minimapView = new DocumentMinimapView(new CGRect(0.0f, 0.0f, 200.0f, 200.0f));
    private final DocumentTypeListView typeListView = new DocumentTypeListView(new CGRect(0.0f, 0.0f, 200.0f, 16.0f));
    private final DrawerToolbar rightToolbar = new DrawerToolbar(new CGRect(0.0f, 0.0f, 200.0f, 480.0f));
    private final ArrayList<AdvancedPanel> allPanels = new ArrayList();
    private SkinDocumentNode selectedNode;
    private final DocumentEditor editor;

    public AdvancedRightCardPanel(DocumentEditor editor, CGRect frame) {
        super(frame);
        this.editor = editor;
        this.init();
        this.setup(frame);
    }

    private void init() {
    }

    private void setup(CGRect rect) {
        float h1 = rect.height * 0.35f;
        float h2 = rect.height * 0.65f;
        UIImage image = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build();
        UIView bg1 = new UIView(this.bounds().insetBy(4.0f, 4.0f, h2, 4.0f));
        bg1.setContents(image);
        bg1.setAutoresizingMask(34);
        this.addSubview(bg1);
        this.typeListView.setFrame(new CGRect(0.0f, 0.0f, bg1.bounds().width(), 20.0f));
        this.typeListView.setMaxRows(16);
        this.typeListView.setAutoresizingMask(34);
        this.typeListView.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, it) -> {
            SkinDocumentType type = self.typeListView.selectedType();
            if (type != null) {
                self.editor.changeTypeAction(type);
            }
        });
        this.typeListView.reloadData();
        bg1.insertViewAtIndex(this.typeListView, 0);
        this.minimapView.setFrame(bg1.bounds().insetBy(20.0f, 0.0f, 0.0f, 0.0f));
        this.minimapView.setAutoresizingMask(18);
        this.minimapView.setDelegate(this);
        bg1.insertViewAtIndex(this.minimapView, 0);
        UIView bg2 = new UIView(this.bounds().insetBy(h1 + 4.0f, 4.0f, 4.0f, 4.0f));
        bg2.setAutoresizingMask(18);
        bg2.setContents(image);
        this.addSubview(bg2);
        this.rightToolbar.setFrame(bg2.bounds().insetBy(0.0f, 0.0f, 0.0f, 0.0f));
        this.rightToolbar.setAutoresizingMask(18);
        bg2.addSubview(this.rightToolbar);
        this.addRightPanel(new AdvancedGeneralPanel(this.editor));
        this.addRightPanel(new AdvancedSettingPanel(this.editor));
        this.addRightPanel(new AdvancedBonePanel(this.editor));
    }

    @Override
    public void treeViewDidSelect(TreeView treeView, TreeNode nodeView) {
        SkinDocumentNode node = (SkinDocumentNode)nodeView.contents();
        if (Objects.equal((Object)this.selectedNode, (Object)node)) {
            return;
        }
        this.selectedNode = node;
        this.editor.connector().update(node);
    }

    @Override
    public Collection<UIMenuItem> treeViewShouldShowMenuForNode(TreeView treeView, TreeNode nodeView) {
        SkinDocumentNode node = (SkinDocumentNode)nodeView.contents();
        return this.editor.getNodeMenuItems(node, treeView);
    }

    public void documentDidUpdateNode(SkinDocumentNode node, class_2487 tag) {
        if (Objects.equal((Object)this.selectedNode, (Object)node)) {
            this.editor.connector().update(node);
        }
    }

    protected void addRightPanel(AdvancedPanel panel) {
        UIBarItem barItem = panel.barItem();
        panel.setFrame(this.rightToolbar.bounds());
        panel.sizeToFit();
        this.rightToolbar.addPage(panel, barItem);
        this.allPanels.add(panel);
    }

    public void setMenuController(UIMenuController menuController) {
        this.minimapView.setMenuController(menuController);
    }

    public UIMenuController menuController() {
        return this.minimapView.menuController();
    }

    public DocumentMinimapView minimapView() {
        return this.minimapView;
    }

    public DocumentTypeListView typeListView() {
        return this.typeListView;
    }
}

