/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UITextField;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Objects;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateOutfitMakerPacket;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.User.ABI;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class OutfitMakerWindow
extends MenuWindow<OutfitMakerMenu> {
    private final UIButton saveButton = new UIButton(new CGRect(146.0f, 120.0f, 20.0f, 20.0f));
    private final UITextField nameTextField = new UITextField(new CGRect(8.0f, 18.0f, 158.0f, 16.0f));
    private final UITextField flavourTextField = new UITextField(new CGRect(8.0f, 38.0f, 158.0f, 16.0f));
    private final OutfitMakerBlockEntity blockEntity;

    public OutfitMakerWindow(OutfitMakerMenu container, class_1661 inventory, NSString title) {
        super(container, inventory, title);
        this.setBackgroundView(UIImage.of(ModTextures.OUTFIT_MAKER).build());
        this.setFrame(new CGRect(0.0f, 0.0f, 176.0f, 240.0f));
        this.blockEntity = (OutfitMakerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        this.setupTextField(this.nameTextField, this.blockEntity.itemName(), "outfit-maker.skinName");
        this.setupTextField(this.flavourTextField, this.blockEntity.itemFlavour(), "outfit-maker.skinFlavour");
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(1.0f, 0.0f));
        offsets.put(2, new CGPoint(0.0f, 1.0f));
        offsets.put(3, new CGPoint(1.0f, 1.0f));
        this.saveButton.setImage(UIImage.of(ModTextures.OUTFIT_MAKER).uv(176.0f, 224.0f).fixed(16.0f, 16.0f).unzip(offsets::get).build(), 7);
        this.saveButton.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        this.saveButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, OutfitMakerWindow::saveSkin);
        this.addSubview(this.saveButton);
    }

    private void saveSkin(UIControl sender) {
        if (!((OutfitMakerMenu)this.menu).shouldCrafting()) {
            return;
        }
        GameProfile origin = ABI.getGameProfile(class_310.method_1551().method_1548());
        class_2487 nbt = DataSerializers.writeGameProfile(new class_2487(), origin);
        NetworkManager.sendToServer(UpdateOutfitMakerPacket.Field.ITEM_CRAFTING.buildPacket(this.blockEntity, nbt));
    }

    private void saveSkinInfo(UIControl textField) {
        String value = this.nameTextField.text();
        UpdateOutfitMakerPacket.Field<String> field = UpdateOutfitMakerPacket.Field.ITEM_NAME;
        if (textField == this.flavourTextField) {
            field = UpdateOutfitMakerPacket.Field.ITEM_FLAVOUR;
            value = this.flavourTextField.text();
        }
        if (Objects.equals(value, field.get(this.blockEntity))) {
            return;
        }
        NetworkManager.sendToServer(field.buildPacket(this.blockEntity, value));
    }

    private void setupTextField(UITextField textField, String value, String placeholderKey) {
        textField.setMaxLength(40);
        textField.setText(value);
        textField.setPlaceholder(NSString.localizedString(placeholderKey, new Object[0]));
        textField.addTarget(this, UIControl.Event.EDITING_DID_END, OutfitMakerWindow::saveSkinInfo);
        this.addSubview(textField);
    }

    @Override
    public boolean shouldRenderExtendScreen() {
        return true;
    }
}

