/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenRotation;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class SkinCubeBlockEntity
extends UpdatableBlockEntity
implements IBlockPaintable {
    protected BlockPaintColor colors = new BlockPaintColor();
    protected boolean customRenderer = false;

    public SkinCubeBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.colors = serializer.read(CodingKeys.COLORS);
        this.customRenderer = this.checkRendererFromColors();
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.COLORS, this.colors);
    }

    private boolean checkRendererFromColors() {
        for (SkinPaintColor color : this.colors.values()) {
            if (color.paintType() == SkinPaintTypes.NORMAL) continue;
            return true;
        }
        return false;
    }

    private OpenDirection getResolvedDirection(OpenDirection dir) {
        return switch (this.getDirection()) {
            case class_2350.field_11035 -> OpenRotation.CLOCKWISE_180.rotate(dir);
            case class_2350.field_11039 -> OpenRotation.CLOCKWISE_90.rotate(dir);
            case class_2350.field_11034 -> OpenRotation.COUNTERCLOCKWISE_90.rotate(dir);
            default -> dir;
        };
    }

    @Override
    public SkinPaintColor getColor(OpenDirection direction) {
        return this.colors.getOrDefault(this.getResolvedDirection(direction), SkinPaintColor.WHITE);
    }

    @Override
    public void setColor(OpenDirection direction, SkinPaintColor color) {
        this.colors.put(this.getResolvedDirection(direction), color);
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    @Override
    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        colors.forEach((direction, color) -> this.colors.put(this.getResolvedDirection((OpenDirection)direction), (SkinPaintColor)color));
        this.customRenderer = this.checkRendererFromColors();
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500((class_2769)ArmourerBlock.field_11177).orElse(class_2350.field_11043);
    }

    public boolean isCustomRenderer() {
        return this.customRenderer;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPaintColor> COLORS = IDataSerializerKey.create("Color", BlockPaintColor.CODEC, BlockPaintColor.WHITE, BlockPaintColor.WHITE::copy);

        private CodingKeys() {
        }
    }
}

