/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.api.client;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;

public interface IVertexConsumer {
    public IVertexConsumer vertex(float var1, float var2, float var3);

    public IVertexConsumer color(int var1, int var2, int var3, int var4);

    public IVertexConsumer uv(float var1, float var2);

    public IVertexConsumer overlayCoords(int var1, int var2);

    public IVertexConsumer uv2(int var1, int var2);

    public IVertexConsumer normal(float var1, float var2, float var3);

    public void endVertex();

    default public void vertex(float x, float y, float z, int color, float u, float v, int overlay, int light, float nx, float ny, float nz) {
        this.vertex(x, y, z);
        this.color(color);
        this.uv(u, v);
        this.overlayCoords(overlay);
        this.uv2(light);
        this.normal(nx, ny, nz);
        this.endVertex();
    }

    default public IVertexConsumer color(float r, float g, float b, float a) {
        return this.color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    default public IVertexConsumer color(int color) {
        return this.color(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), ColorUtils.getAlpha(color));
    }

    default public IVertexConsumer uv2(int i) {
        return this.uv2(i & 0xFFFF, i >> 16 & 0xFFFF);
    }

    default public IVertexConsumer overlayCoords(int i) {
        return this.overlayCoords(i & 0xFFFF, i >> 16 & 0xFFFF);
    }

    default public IVertexConsumer vertex(IPoseStack.Pose entry, float x, float y, float z) {
        float[] values = new float[]{x, y, z, 1.0f};
        entry.transformPose(values);
        return this.vertex(values[0], values[1], values[2]);
    }

    default public IVertexConsumer normal(IPoseStack.Pose entry, float x, float y, float z) {
        float[] values = new float[]{x, y, z};
        entry.transformNormal(values);
        return this.normal(values[0], values[1], values[2]);
    }
}

