/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.InterpolableImpl;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.impl.ViewImpl;
import com.apple.library.quartzcore.CAAnimation;
import com.apple.library.quartzcore.CAMediaTimingFunction;
import com.apple.library.quartzcore.CATransaction;
import com.apple.library.uikit.UIView;
import java.util.HashMap;
import java.util.function.Function;

public class UIPresentationDelegate
implements ViewImpl {
    protected final UIView view;
    protected HashMap<String, CAAnimation> animations;

    public UIPresentationDelegate(UIView view) {
        this.view = view;
    }

    @Override
    public UIView self() {
        return this.view;
    }

    @Override
    public CGPoint center() {
        return this._valueForKeyPath("center", UIView::center);
    }

    @Override
    public CGRect bounds() {
        return this._valueForKeyPath("bounds", UIView::bounds);
    }

    @Override
    public CGAffineTransform transform() {
        return this._valueForKeyPath("transform", UIView::transform);
    }

    public CAAnimation animationForKey(String key) {
        if (this.animations != null) {
            return this.animations.get(key);
        }
        return null;
    }

    public <T extends InterpolableImpl<T>> void addAnimationForKeyPath(T oldValue, T newValue, String keyPath) {
        if (!CATransaction._isEnabled()) {
            return;
        }
        CAAnimation animation = CAAnimation.animationWithKeyPath(keyPath);
        animation.setFromValue(oldValue);
        animation.setToValue(newValue);
        this.addAnimationForKeyPath(animation, keyPath);
    }

    public void addAnimationForKeyPath(CAAnimation animation, String keyPath) {
        if (!CATransaction._isEnabled()) {
            return;
        }
        this.removeAnimationForKey(keyPath, true);
        if (this.animations == null) {
            this.animations = new HashMap();
        }
        this.animations.put(keyPath, animation);
        CATransaction._addAnimation(animation, keyPath, () -> this.removeAnimationForKey(keyPath, false));
    }

    public void removeAnimationForKey(String key, boolean notify) {
        if (this.animations == null) {
            return;
        }
        CAAnimation oldValue = this.animations.remove(key);
        if (oldValue != null && notify) {
            CATransaction._removeAnimation(oldValue, key);
        }
        if (this.animations.isEmpty()) {
            this.animations = null;
        }
    }

    public boolean hasAnimations() {
        return this.animations != null && !this.animations.isEmpty();
    }

    @Override
    public CGAffineTransform _invertedTransform() {
        CGAffineTransform transform = this.transform();
        if (transform != this.view.transform()) {
            return transform.inverted();
        }
        return this.view._invertedTransform();
    }

    public <T extends InterpolableImpl<T>> T _valueForKeyPath(String keyPath, Function<UIView, T> getter) {
        CAAnimation animation = this.animationForKey(keyPath);
        if (animation != null) {
            double t = animation._currentTime(CATransaction.currentMediaTime());
            double dur = animation.duration();
            if (t < 0.0 || t >= dur) {
                return (T)((InterpolableImpl)getter.apply(this.view));
            }
            InterpolableImpl fromValue = (InterpolableImpl)ObjectUtilsImpl.unsafeCast(animation.fromValue());
            InterpolableImpl toValue = (InterpolableImpl)ObjectUtilsImpl.unsafeCast(animation.toValue());
            CAMediaTimingFunction f = animation.timingFunction();
            return (T)fromValue.interpolating(toValue, f.applying((float)(t / dur)));
        }
        return (T)((InterpolableImpl)getter.apply(this.view));
    }

    @Override
    public ViewImpl _superviewInViewHierarchy(ViewImpl searchingView) {
        UIView superview = searchingView.self().superview();
        if (superview == null) {
            return null;
        }
        UIPresentationDelegate presentation = superview._presentation;
        if (presentation.hasAnimations()) {
            return presentation;
        }
        return superview;
    }
}

