/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.apple.library.uikit.UIWindowManager;

public class UIPopoverView
extends UIWindow {
    private UIView contentView;

    public UIPopoverView() {
        super(CGRect.ZERO);
        this.setLevel(400);
        this.setBackgroundColor(UIColor.of(0x3F000000));
    }

    public void dismiss() {
        UIWindowManager windowManager = this.getWindowManagerFromView(this);
        if (windowManager != null) {
            windowManager.removeWindow(this);
            windowManager._setNeedsUpdateFocus();
        }
    }

    public void showInView(UIView view) {
        UIWindowManager windowManager = this.getWindowManagerFromView(view);
        if (windowManager != null) {
            windowManager.addWindow(this);
        }
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect rect = this.bounds();
        if (this.contentView != null) {
            this.contentView.setCenter(new CGPoint(rect.width / 2.0f, rect.height / 2.0f));
        }
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
    }

    @Override
    protected boolean shouldPassEventToNextWindow(UIEvent event) {
        return false;
    }

    @Override
    public UIView hitTest(CGPoint point, UIEvent event) {
        UIView view = super.hitTest(point, event);
        if (view != null) {
            return view;
        }
        return this.contentView;
    }

    @Override
    public UIView firstTooltipResponder() {
        UIView view = super.firstTooltipResponder();
        if (view != null) {
            return view;
        }
        return this;
    }

    public UIView contentView() {
        return this.contentView;
    }

    public void setContentView(UIView contentView) {
        if (this.contentView == contentView) {
            return;
        }
        if (this.contentView != null) {
            this.contentView.removeFromSuperview();
        }
        this.contentView = contentView;
        if (this.contentView != null) {
            this.addSubview(this.contentView);
            this.setNeedsLayout();
        }
    }

    private UIWindowManager getWindowManagerFromView(UIView view) {
        if (view instanceof UIWindow) {
            UIWindow window = (UIWindow)view;
            return window.windowManager();
        }
        UIWindow window = view.window();
        if (window != null) {
            return window.windowManager();
        }
        return null;
    }
}

