/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import java.util.Iterator;
import java.util.List;

public class LBSIterator<T> {
    boolean flag;

    public LBSIterator(boolean flag) {
        this.flag = flag;
    }

    public Iterable<T> remaining(List<T> views, T view) {
        int index = this.indexOf(views, view);
        if (this.flag) {
            return () -> new RangeIterator(this, views, index, views.size());
        }
        return () -> new ReverseRangeIterator(this, views, index, 0);
    }

    public Iterable<T> skipping(List<T> views, T view) {
        int index = this.indexOf(views, view);
        if (this.flag) {
            return () -> new RangeIterator(this, views, 0, index);
        }
        return () -> new ReverseRangeIterator(this, views, views.size(), index);
    }

    private int indexOf(List<T> views, T view) {
        if (view != null) {
            return views.indexOf(view);
        }
        return 0;
    }

    private class ReverseRangeIterator
    implements Iterator<T> {
        int offset;
        int size;
        List<T> items;

        ReverseRangeIterator(LBSIterator lBSIterator, List<T> items, int offset, int size) {
            this.items = items;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.offset > this.size;
        }

        @Override
        public T next() {
            return this.items.get(--this.offset);
        }
    }

    private class RangeIterator
    implements Iterator<T> {
        int offset;
        int size;
        List<T> items;

        RangeIterator(LBSIterator lBSIterator, List<T> items, int offset, int size) {
            this.items = items;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.size;
        }

        @Override
        public T next() {
            return this.items.get(this.offset++);
        }
    }
}

