/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.common.conditions;

import com.aetherteam.aether.mixin.mixins.common.accessor.HolderLookupAdapterAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.RegistryOpsAccessor;
import com.aetherteam.aetherfabric.common.conditions.WithConditions;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class ConditionalOps {
    public static final String DEFAULT_CONDITIONS_KEY = "fabric:load_conditions";
    public static final String CONDITIONAL_VALUE_KEY = "fabric:value";

    public static <T> Codec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodec(ownerCodec, DEFAULT_CONDITIONS_KEY);
    }

    public static <T> Codec<Optional<T>> createConditionalCodec(Codec<T> ownerCodec, String conditionalsKey) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, conditionalsKey).xmap(r -> r.map(WithConditions::carrier), r -> r.map(i -> new WithConditions<Object>(List.of(), i)));
    }

    public static <T> Codec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec) {
        return ConditionalOps.createConditionalCodecWithConditions(ownerCodec, DEFAULT_CONDITIONS_KEY);
    }

    public static <T> Codec<Optional<WithConditions<T>>> createConditionalCodecWithConditions(Codec<T> ownerCodec, String conditionalsKey) {
        return Codec.of(new ConditionalEncoder<T>(conditionalsKey, (Codec<List<ResourceCondition>>)ResourceCondition.LIST_CODEC, ownerCodec), new ConditionalDecoder<T>(conditionalsKey, (Codec<ResourceCondition>)ResourceCondition.CONDITION_CODEC, ownerCodec));
    }

    private record ConditionalEncoder<A>(String conditionalsPropertyKey, Codec<List<ResourceCondition>> conditionsCodec, Encoder<A> innerCodec) implements Encoder<Optional<WithConditions<A>>>
    {
        public <T> DataResult<T> encode(Optional<WithConditions<A>> input, DynamicOps<T> ops, T prefix) {
            if (ops.compressMaps()) {
                return DataResult.error(() -> "Cannot use ConditionalCodec with compressing DynamicOps");
            }
            if (input.isEmpty()) {
                return DataResult.error(() -> "Cannot encode empty Optional with a ConditionalEncoder. We don't know what to encode to!");
            }
            WithConditions<A> withConditions = input.get();
            if (withConditions.conditions().isEmpty()) {
                return this.innerCodec.encode(withConditions.carrier(), ops, prefix);
            }
            RecordBuilder recordBuilder = ops.mapBuilder();
            recordBuilder.add(this.conditionalsPropertyKey, this.conditionsCodec.encodeStart(ops, withConditions.conditions()));
            DataResult encodedInner = this.innerCodec.encodeStart(ops, withConditions.carrier());
            return encodedInner.flatMap(inner -> ops.getMap(inner).map(innerMap -> {
                if (innerMap.get(this.conditionalsPropertyKey) != null || innerMap.get(ConditionalOps.CONDITIONAL_VALUE_KEY) != null) {
                    return DataResult.error(() -> "Cannot wrap a value that already uses the condition or value key with a ConditionalCodec.");
                }
                innerMap.entries().forEach(pair -> recordBuilder.add(pair.getFirst(), pair.getSecond()));
                return recordBuilder.build(prefix);
            }).result().orElseGet(() -> {
                recordBuilder.add(ConditionalOps.CONDITIONAL_VALUE_KEY, inner);
                return recordBuilder.build(prefix);
            }));
        }

        @Override
        public String toString() {
            return "Conditional[" + String.valueOf(this.innerCodec) + "]";
        }
    }

    private record ConditionalDecoder<A>(String conditionalsPropertyKey, Codec<ResourceCondition> conditionsCodec, Decoder<A> innerCodec) implements Decoder<Optional<WithConditions<A>>>
    {
        public <T> DataResult<Pair<Optional<WithConditions<A>>, T>> decode(DynamicOps<T> ops, T input) {
            class_7225.class_7874 ctx;
            if (ops instanceof class_6903) {
                class_6903 registryOps = (class_6903)ops;
                v0 = ((HolderLookupAdapterAccessor)((RegistryOpsAccessor)registryOps).aetherFabric$lookup()).aetherFabric$lookupProvider();
            } else {
                v0 = ctx = null;
            }
            if (ops.compressMaps()) {
                return DataResult.error(() -> "Cannot use ConditionalCodec with compressing DynamicOps");
            }
            return ops.getMap(input).map(inputMap -> {
                Object conditionsDataCarrier = inputMap.get(this.conditionalsPropertyKey);
                if (conditionsDataCarrier == null) {
                    return this.innerCodec.decode(ops, input).map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(carrier))));
                }
                return this.conditionsCodec.decode(ops, conditionsDataCarrier).flatMap(conditionsCarrier -> {
                    DataResult innerDecodeResult;
                    ResourceCondition condition = (ResourceCondition)conditionsCarrier.getFirst();
                    boolean conditionsMatch = condition.test(ctx);
                    if (!conditionsMatch) {
                        return DataResult.success((Object)Pair.of(Optional.empty(), (Object)input));
                    }
                    Object valueDataCarrier = inputMap.get(ConditionalOps.CONDITIONAL_VALUE_KEY);
                    if (valueDataCarrier != null) {
                        innerDecodeResult = this.innerCodec.decode(ops, valueDataCarrier);
                    } else {
                        Object conditionalsKey = ops.createString(this.conditionalsPropertyKey);
                        Object mapForDecoding = ops.createMap(inputMap.entries().filter(pair -> !pair.getFirst().equals(conditionalsKey)));
                        innerDecodeResult = this.innerCodec.decode(ops, mapForDecoding);
                    }
                    DataResult ret = innerDecodeResult.map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(List.of(condition), carrier))));
                    return ret;
                });
            }).result().orElseGet(() -> this.innerCodec.decode(ops, input).map(result -> result.mapFirst(carrier -> Optional.of(new WithConditions<Object>(carrier)))));
        }
    }
}

