/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.builder;

import com.aetherteam.aether.recipe.AetherBookCategory;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.serializer.AetherCookingSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class AetherCookingRecipeBuilder
implements class_5797 {
    private final class_7800 category;
    private final AetherBookCategory bookCategory;
    private final class_1799 result;
    private final class_1856 ingredient;
    private final float experience;
    private final int cookingTime;
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private final AetherCookingSerializer.CookieBaker<?> factory;

    public AetherCookingRecipeBuilder(class_7800 category, AetherBookCategory bookCategory, class_1799 result, class_1856 ingredient, float experience, int cookingTime, AetherCookingSerializer.CookieBaker<?> factory) {
        this.category = category;
        this.bookCategory = bookCategory;
        this.result = result;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.factory = factory;
    }

    public static AetherCookingRecipeBuilder generic(class_1856 ingredient, class_7800 category, class_1935 result, float experience, int cookingTime, AetherCookingSerializer<?> serializer, AetherCookingSerializer.CookieBaker<?> factory) {
        return new AetherCookingRecipeBuilder(category, AetherCookingRecipeBuilder.determineRecipeCategory(serializer, category), new class_1799(result), ingredient, experience, cookingTime, factory);
    }

    public AetherCookingRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public AetherCookingRecipeBuilder unlockedBy(String criterionName, class_175<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public void method_17972(class_8790 recipeOutput, class_2960 id) {
        this.ensureValid(id);
        class_161.class_162 advancement$builder = recipeOutput.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_8782.class_8797.field_1257);
        Objects.requireNonNull(advancement$builder);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancement$builder).method_705(arg_0, arg_1));
        Object recipe = this.factory.create(Objects.requireNonNullElse(this.group, ""), this.bookCategory, this.ingredient, this.result, this.experience, this.cookingTime);
        recipeOutput.method_53819(id, recipe, advancement$builder.method_695(id.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private static AetherBookCategory determineRecipeCategory(class_1865<? extends class_1874> serializer, class_7800 category) {
        if (serializer == AetherRecipeSerializers.ENCHANTING.get()) {
            return switch (category) {
                case class_7800.field_40634, class_7800.field_40635 -> AetherBookCategory.ENCHANTING_BLOCKS;
                case class_7800.field_40640 -> AetherBookCategory.ENCHANTING_FOOD;
                default -> AetherBookCategory.ENCHANTING_MISC;
            };
        }
        if (serializer == AetherRecipeSerializers.REPAIRING.get()) {
            return AetherBookCategory.ENCHANTING_REPAIR;
        }
        if (serializer == AetherRecipeSerializers.FREEZING.get()) {
            return switch (category) {
                case class_7800.field_40634, class_7800.field_40635 -> AetherBookCategory.FREEZABLE_BLOCKS;
                default -> AetherBookCategory.FREEZABLE_MISC;
            };
        }
        throw new IllegalStateException("Unknown cooking recipe type; may not belong to the Aether");
    }

    private void ensureValid(class_2960 id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

