/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public final class EquipmentUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFullStrength(class_1309 attacker) {
        boolean combatifyLoaded = FabricLoader.getInstance().isModLoaded("combatify");
        if (!(attacker instanceof class_1657)) return true;
        class_1657 player = (class_1657)attacker;
        if (combatifyLoaded) {
            if (!(player.method_7261(1.0f) >= 1.95f)) return false;
            return true;
        } else if (!(player.method_7261(1.0f) >= 1.0f)) return false;
        return true;
    }

    public static double calculateZaniteBuff(class_1799 stack, double baseValue) {
        return baseValue * (2.0 * (double)stack.method_7919() / (double)stack.method_7936() + 0.5);
    }

    @Nullable
    public static SlotEntryReference getGloves(class_1309 entity) {
        Optional<SlotEntryReference> slotResultOptional = EquipmentUtil.findFirstAccessory(entity, (class_1799 stack) -> stack.method_7909() instanceof GlovesItem);
        return slotResultOptional.orElse(null);
    }

    public static List<SlotEntryReference> getZaniteRings(class_1309 entity) {
        return EquipmentUtil.getAccessories(entity, (class_1792)AetherItems.ZANITE_RING.get());
    }

    @Nullable
    public static SlotEntryReference getZanitePendant(class_1309 entity) {
        return EquipmentUtil.getAccessory(entity, (class_1792)AetherItems.ZANITE_PENDANT.get());
    }

    public static boolean hasFreezingAccessory(class_1309 entity) {
        return EquipmentUtil.hasAccessory(entity, (class_1792)AetherItems.ICE_PENDANT.get()) || EquipmentUtil.hasAccessory(entity, (class_1792)AetherItems.ICE_RING.get());
    }

    public static boolean hasSwetCape(class_1309 entity) {
        return EquipmentUtil.hasAccessory(entity, (class_1792)AetherItems.SWET_CAPE.get());
    }

    public static boolean hasInvisibilityCloak(class_1309 entity) {
        return EquipmentUtil.hasAccessory(entity, (class_1792)AetherItems.INVISIBILITY_CLOAK.get());
    }

    public static boolean hasCape(class_1309 entity) {
        return EquipmentUtil.findFirstAccessory(entity, (class_1799 stack) -> stack.method_7909() instanceof CapeItem).isPresent();
    }

    @Nullable
    public static SlotEntryReference getCape(class_1309 entity) {
        return EquipmentUtil.findFirstAccessory(entity, (class_1799 stack) -> stack.method_7909() instanceof CapeItem).orElse(null);
    }

    public static boolean hasAccessory(class_1309 entity, class_1792 item) {
        return EquipmentUtil.findFirstAccessory(entity, item).isPresent();
    }

    @Nullable
    public static SlotEntryReference getAccessory(class_1309 entity, class_1792 item) {
        return EquipmentUtil.findFirstAccessory(entity, item).orElse(null);
    }

    public static List<SlotEntryReference> getAccessories(class_1309 entity, class_1792 item) {
        AccessoriesCapability accessories = AccessoriesCapability.get((class_1309)entity);
        if (accessories != null) {
            return accessories.getEquipped(item);
        }
        return List.of();
    }

    public static boolean hasSentryBoots(class_1309 entity) {
        return entity.method_6118(class_1304.field_6166).method_31574((class_1792)AetherItems.SENTRY_BOOTS.get());
    }

    public static boolean hasFullGravititeSet(class_1309 entity) {
        return EquipmentUtil.hasArmorSet(entity, (class_1792)AetherItems.GRAVITITE_HELMET.get(), (class_1792)AetherItems.GRAVITITE_CHESTPLATE.get(), (class_1792)AetherItems.GRAVITITE_LEGGINGS.get(), (class_1792)AetherItems.GRAVITITE_BOOTS.get(), (class_1792)AetherItems.GRAVITITE_GLOVES.get());
    }

    public static boolean hasFullValkyrieSet(class_1309 entity) {
        return EquipmentUtil.hasArmorSet(entity, (class_1792)AetherItems.VALKYRIE_HELMET.get(), (class_1792)AetherItems.VALKYRIE_CHESTPLATE.get(), (class_1792)AetherItems.VALKYRIE_LEGGINGS.get(), (class_1792)AetherItems.VALKYRIE_BOOTS.get(), (class_1792)AetherItems.VALKYRIE_GLOVES.get());
    }

    public static boolean hasFullNeptuneSet(class_1309 entity) {
        return EquipmentUtil.hasArmorSet(entity, (class_1792)AetherItems.NEPTUNE_HELMET.get(), (class_1792)AetherItems.NEPTUNE_CHESTPLATE.get(), (class_1792)AetherItems.NEPTUNE_LEGGINGS.get(), (class_1792)AetherItems.NEPTUNE_BOOTS.get(), (class_1792)AetherItems.NEPTUNE_GLOVES.get());
    }

    public static boolean hasFullPhoenixSet(class_1309 entity) {
        return EquipmentUtil.hasArmorSet(entity, (class_1792)AetherItems.PHOENIX_HELMET.get(), (class_1792)AetherItems.PHOENIX_CHESTPLATE.get(), (class_1792)AetherItems.PHOENIX_LEGGINGS.get(), (class_1792)AetherItems.PHOENIX_BOOTS.get(), (class_1792)AetherItems.PHOENIX_GLOVES.get());
    }

    public static boolean hasAnyPhoenixArmor(class_1309 entity) {
        return EquipmentUtil.hasAnyArmor(entity, (class_1792)AetherItems.PHOENIX_HELMET.get(), (class_1792)AetherItems.PHOENIX_CHESTPLATE.get(), (class_1792)AetherItems.PHOENIX_LEGGINGS.get(), (class_1792)AetherItems.PHOENIX_BOOTS.get(), (class_1792)AetherItems.PHOENIX_GLOVES.get());
    }

    private static boolean hasArmorSet(class_1309 entity, class_1792 helmet, class_1792 chestplate, class_1792 leggings, class_1792 boots, class_1792 gloves) {
        return entity.method_6118(class_1304.field_6169).method_31574(helmet) && entity.method_6118(class_1304.field_6174).method_31574(chestplate) && entity.method_6118(class_1304.field_6172).method_31574(leggings) && entity.method_6118(class_1304.field_6166).method_31574(boots) && ((Boolean)AetherConfig.SERVER.require_gloves.get() == false || EquipmentUtil.findFirstAccessory(entity, gloves).isPresent());
    }

    private static boolean hasAnyArmor(class_1309 entity, class_1792 helmet, class_1792 chestplate, class_1792 leggings, class_1792 boots, class_1792 gloves) {
        return entity.method_6118(class_1304.field_6169).method_31574(helmet) || entity.method_6118(class_1304.field_6174).method_31574(chestplate) || entity.method_6118(class_1304.field_6172).method_31574(leggings) || entity.method_6118(class_1304.field_6166).method_31574(boots) || EquipmentUtil.findFirstAccessory(entity, gloves).isPresent();
    }

    public static Optional<SlotEntryReference> findFirstAccessory(class_1309 entity, class_1792 item) {
        return EquipmentUtil.findFirstAccessory(entity, (class_1799 itemStack) -> itemStack.method_31574(item));
    }

    public static Optional<SlotEntryReference> findFirstAccessory(class_1309 entity, Predicate<class_1799> predicate) {
        SlotEntryReference slotEntryReference;
        AccessoriesCapability accessories = AccessoriesCapability.get((class_1309)entity);
        if (accessories != null && (slotEntryReference = accessories.getFirstEquipped(predicate)) != null) {
            return Optional.of(slotEntryReference);
        }
        return Optional.empty();
    }
}

