/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherDataMaps;
import com.aetherteam.aether.integration.rei.AetherREIServerPlugin;
import com.aetherteam.aether.integration.rei.FuelRecipe;
import com.aetherteam.aether.integration.rei.categories.ban.BlockBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.ItemBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.PlacementBanRecipeDisplay;
import com.aetherteam.aether.integration.rei.categories.block.AetherBlockStateRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.block.BiomeParameterRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeDisplay;
import com.aetherteam.aether.inventory.menu.AltarMenu;
import com.aetherteam.aether.inventory.menu.FreezerMenu;
import com.aetherteam.aether.inventory.menu.IncubatorMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.AccessoryFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.AmbrosiumRecipe;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import com.aetherteam.aether.recipe.recipes.block.SwetBallRecipe;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.EnchantingRecipe;
import com.aetherteam.aether.recipe.recipes.item.FreezingRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.aetherteam.nitrogen.integration.rei.categories.fuel.AbstractFuelCategory;
import com.aetherteam.nitrogen.integration.rei.displays.BlockStateRecipeDisplay;
import com.aetherteam.nitrogen.integration.rei.displays.FuelDisplay;
import com.aetherteam.nitrogen.recipe.recipes.AbstractBlockStateRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class AetherREIClientPlugin
implements REIClientPlugin {
    private static final class_2960 LIT_PROGRESS_TRANSPARENT_TEXTURE = class_2960.method_60655((String)"aether", (String)"menu/lit_progress_transparent");
    private static final class_2960 LIT_PROGRESS_BACKGROUND_TEXTURE = class_2960.method_60655((String)"aether", (String)"menu/lit_progress_background");

    public static List<FuelRecipe> getFuelRecipes() {
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>();
        class_7923.field_41178.aetherFabric$getDataMap(AetherDataMaps.ALTAR_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new class_1799((class_1935)class_7923.field_41178.method_29107(item))), fuel.burnTime(), (class_2248)AetherBlocks.ALTAR.get())));
        class_7923.field_41178.aetherFabric$getDataMap(AetherDataMaps.FREEZER_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new class_1799((class_1935)class_7923.field_41178.method_29107(item))), fuel.burnTime(), (class_2248)AetherBlocks.FREEZER.get())));
        class_7923.field_41178.aetherFabric$getDataMap(AetherDataMaps.INCUBATOR_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new class_1799((class_1935)class_7923.field_41178.method_29107(item))), fuel.burnTime(), (class_2248)AetherBlocks.INCUBATOR.get())));
        return fuelRecipes;
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(ItemBanRecipe.class, AetherRecipeTypes.ITEM_PLACEMENT_BAN.get(), recipe -> PlacementBanRecipeDisplay.ofItem((ItemBanRecipe)recipe.comp_1933()));
        registry.registerRecipeFiller(BlockBanRecipe.class, AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get(), recipe -> PlacementBanRecipeDisplay.ofBlock((BlockBanRecipe)recipe.comp_1933()));
        registry.registerRecipeFiller(AccessoryFreezableRecipe.class, AetherRecipeTypes.ACCESSORY_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ACCESSORY_FREEZABLE, (AbstractBlockStateRecipe)((AccessoryFreezableRecipe)recipe.comp_1933())));
        registry.registerRecipeFiller(AmbrosiumRecipe.class, AetherRecipeTypes.AMBROSIUM_ENCHANTING.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.AMBROSIUM_ENCHANTING, (AbstractBlockStateRecipe)((AmbrosiumRecipe)recipe.comp_1933())));
        registry.registerRecipeFiller(IcestoneFreezableRecipe.class, AetherRecipeTypes.ICESTONE_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ICESTONE_FREEZABLE, (AbstractBlockStateRecipe)((IcestoneFreezableRecipe)recipe.comp_1933())));
        registry.registerRecipeFiller(PlacementConversionRecipe.class, AetherRecipeTypes.PLACEMENT_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.PLACEMENT_CONVERSION, (AbstractBlockStateRecipe)((PlacementConversionRecipe)recipe.comp_1933())));
        registry.registerRecipeFiller(SwetBallRecipe.class, AetherRecipeTypes.SWET_BALL_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.SWET_BALL_CONVERSION, (AbstractBlockStateRecipe)((SwetBallRecipe)recipe.comp_1933())));
        for (FuelRecipe fuelRecipe : AetherREIClientPlugin.getFuelRecipes()) {
            registry.add((Display)new FuelDisplay(AetherREIServerPlugin.AETHER_FUEL, fuelRecipe.inputItems(), fuelRecipe.burnTime(), fuelRecipe.usageBlock()));
        }
        for (class_8786 recipe2 : registry.getRecipeManager().method_30027(AetherRecipeTypes.ENCHANTING.get())) {
            class_1860 class_18602 = recipe2.comp_1933();
            if (class_18602 instanceof EnchantingRecipe) {
                EnchantingRecipe enchanting = (EnchantingRecipe)class_18602;
                registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_ENCHANTING, enchanting));
                continue;
            }
            class_18602 = recipe2.comp_1933();
            if (!(class_18602 instanceof AltarRepairRecipe)) continue;
            AltarRepairRecipe repair = (AltarRepairRecipe)class_18602;
            registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_REPAIR, repair));
        }
        registry.registerFiller(o -> {
            class_8786 holder;
            return o instanceof class_8786 && (holder = (class_8786)o).comp_1933() instanceof EnchantingRecipe;
        }, recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_ENCHANTING, (EnchantingRecipe)((class_8786)recipe).comp_1933()));
        registry.registerFiller(o -> {
            class_8786 holder;
            return o instanceof class_8786 && (holder = (class_8786)o).comp_1933() instanceof AltarRepairRecipe;
        }, recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_REPAIR, (AltarRepairRecipe)((class_8786)recipe).comp_1933()));
        registry.registerRecipeFiller(FreezingRecipe.class, AetherRecipeTypes.FREEZING.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.FREEZING, (FreezingRecipe)recipe.comp_1933()));
        registry.registerRecipeFiller(IncubationRecipe.class, AetherRecipeTypes.INCUBATION.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.INCUBATING, (IncubationRecipe)recipe.comp_1933()));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new BlockBanRecipeCategory());
        registry.add((DisplayCategory)new ItemBanRecipeCategory());
        registry.add(AetherBlockStateRecipeCategory.accessoryFreezable());
        registry.add(AetherBlockStateRecipeCategory.ambrosium());
        registry.add(AetherBlockStateRecipeCategory.icestoneFreezable());
        registry.add(BiomeParameterRecipeCategory.placementConversion());
        registry.add(BiomeParameterRecipeCategory.swetBall());
        registry.add((DisplayCategory)new AbstractFuelCategory(this, AetherREIServerPlugin.AETHER_FUEL, LIT_PROGRESS_TRANSPARENT_TEXTURE, LIT_PROGRESS_BACKGROUND_TEXTURE){

            public class_2561 getTitle() {
                return class_2561.method_43471((String)"gui.aether.jei.fuel");
            }
        });
        registry.add(AetherCookingRecipeCategory.altarRepair());
        registry.add(AetherCookingRecipeCategory.altarEnchanting());
        registry.add(AetherCookingRecipeCategory.freezing());
        registry.add(AetherCookingRecipeCategory.incubating());
        registry.addWorkstations(AetherREIServerPlugin.AETHER_FUEL, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)AetherBlocks.FREEZER.get())), EntryStacks.of((class_1935)((class_1935)AetherBlocks.ALTAR.get())), EntryStacks.of((class_1935)((class_1935)AetherBlocks.INCUBATOR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.FREEZING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)AetherBlocks.FREEZER.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_REPAIR, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_ENCHANTING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.INCUBATING, new EntryStack[]{EntryStacks.of((class_1935)((class_1935)AetherBlocks.INCUBATOR.get()))});
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_ENCHANTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_REPAIR, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(FreezerMenu.class, AetherREIServerPlugin.FREEZING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(IncubatorMenu.class, AetherREIServerPlugin.INCUBATING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
    }
}

