/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.EntityEvents;
import com.aetherteam.aetherfabric.events.LivingEntityEvents;
import com.aetherteam.aetherfabric.events.ProjectileEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1676;
import net.minecraft.class_239;
import org.apache.commons.lang3.mutable.MutableFloat;

public class WeaponAbilityListener {
    public static void listen() {
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> WeaponAbilityListener.onDartHurt(entity, source));
        ProjectileEvents.ON_IMPACT.register(WeaponAbilityListener::onArrowHit);
        EntityEvents.STRUCK_BY_LIGHTNING.register(WeaponAbilityListener::onLightningStrike);
        LivingEntityEvents.ON_DAMAGE.register((entity, source, originalDamage, newDamage) -> WeaponAbilityListener.onEntityDamage(entity, source, newDamage));
    }

    public static void onDartHurt(class_1309 livingEntity, class_1282 damageSource) {
        AbilityHooks.WeaponHooks.stickDart(livingEntity, damageSource);
    }

    public static void onArrowHit(class_1676 projectile, class_239 hitResult, CancellableCallback callback) {
        if (!callback.isCanceled()) {
            AbilityHooks.WeaponHooks.phoenixArrowHit(hitResult, projectile);
        }
    }

    public static void onLightningStrike(class_1297 entity, class_1538 lightningBolt, CancellableCallback callback) {
        if (!callback.isCanceled() && AbilityHooks.WeaponHooks.lightningTracking(entity, lightningBolt)) {
            callback.setCanceled(true);
        }
    }

    public static void onEntityDamage(class_1309 targetEntity, class_1282 damageSource, MutableFloat damage) {
        class_1297 sourceEntity = damageSource.method_5526();
        damage.setValue(AbilityHooks.WeaponHooks.reduceWeaponEffectiveness(targetEntity, sourceEntity, damage.floatValue()));
        damage.setValue(AbilityHooks.WeaponHooks.reduceArmorEffectiveness(targetEntity, sourceEntity, damage.floatValue()));
    }
}

