/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.item.accessories.abilities.ShieldOfRepulsionAccessory;
import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.PlayerEvents;
import com.aetherteam.aetherfabric.events.ProjectileEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class AccessoryAbilityListener {
    public static void listen() {
        PlayerBlockBreakEvents.AFTER.register((level, player, pos, state, blockEntity) -> AccessoryAbilityListener.onBlockBreak(level, player, pos, state));
        PlayerEvents.ON_BLOCK_DESTROY.register(AccessoryAbilityListener::onMiningSpeed);
        ProjectileEvents.ON_IMPACT.register(AccessoryAbilityListener::onProjectileImpact);
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> AccessoryAbilityListener.onEntityHurt(entity, source));
    }

    public static void onBlockBreak(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        AbilityHooks.AccessoryHooks.damageZaniteRing((class_1309)player, (class_1936)level, state, pos);
        AbilityHooks.AccessoryHooks.damageZanitePendant((class_1309)player, (class_1936)level, state, pos);
    }

    public static void onMiningSpeed(class_1657 player, class_2680 blockState, MutableFloat speed, CancellableCallback callback) {
        if (!callback.isCanceled()) {
            speed.setValue(AbilityHooks.AccessoryHooks.handleZaniteRingAbility((class_1309)player, speed.getValue().floatValue()));
            speed.setValue(AbilityHooks.AccessoryHooks.handleZanitePendantAbility((class_1309)player, speed.getValue().floatValue()));
        }
    }

    public static void onTargetSet(class_1309 livingEntity, @Nullable class_1297 lookingEntity, MutableDouble visibilityValue) {
        if (AbilityHooks.AccessoryHooks.preventTargeting(livingEntity, lookingEntity) && !AbilityHooks.AccessoryHooks.recentlyAttackedWithInvisibility(livingEntity, lookingEntity)) {
            visibilityValue.setValue(0.0);
        }
        if (AbilityHooks.AccessoryHooks.recentlyAttackedWithInvisibility(livingEntity, lookingEntity)) {
            visibilityValue.setValue(1.0);
        }
    }

    public static void onProjectileImpact(class_1676 projectile, class_239 hitResult, CancellableCallback callback) {
        if (ShieldOfRepulsionAccessory.deflectProjectile(hitResult, projectile)) {
            callback.setCanceled(true);
        }
    }

    public static boolean onEntityHurt(class_1309 livingEntity, class_1282 damageSource) {
        AbilityHooks.AccessoryHooks.setAttack(damageSource);
        return !AbilityHooks.AccessoryHooks.preventMagmaDamage(livingEntity, damageSource);
    }
}

