/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerLevelAccessor;
import com.aetherteam.aether.network.packet.clientbound.AetherTravelPacket;
import com.aetherteam.aether.network.packet.clientbound.LeavingAetherPacket;
import com.aetherteam.aether.world.AetherLevelData;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class DimensionHooks {
    public static boolean playerLeavingAether;
    public static boolean displayAetherTravel;
    public static int teleportationTimer;

    public static void startInAether(class_1657 player) {
        AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER);
        if (((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue()) {
            class_5454 transition;
            class_3218 aetherLevel;
            class_3222 serverPlayer;
            MinecraftServer server;
            if (aetherPlayer.canSpawnInAether() && player instanceof class_3222 && (server = (serverPlayer = (class_3222)player).method_37908().method_8503()) != null && (aetherLevel = server.method_3847(AetherDimensions.AETHER_LEVEL)) != null && serverPlayer.method_37908().method_27983() == class_1937.field_25179 && serverPlayer.method_5731(transition = new class_5454(aetherLevel, DimensionHooks.checkPositionsForInitialSpawn((class_1937)aetherLevel, serverPlayer.method_24515()).method_46558(), class_243.field_1353, serverPlayer.method_36454(), serverPlayer.method_36455(), false, class_5454.field_52245)) != null) {
                serverPlayer.method_26284(AetherDimensions.AETHER_LEVEL, serverPlayer.method_24515(), serverPlayer.method_36454(), true, false);
                aetherPlayer.setCanSpawnInAether(false);
            }
        } else {
            aetherPlayer.setCanSpawnInAether(false);
        }
    }

    private static class_2338 checkPositionsForInitialSpawn(class_1937 level, class_2338 origin) {
        if (!DimensionHooks.isSafe(level, origin)) {
            for (int i = 0; i <= 750; i += 5) {
                for (class_2350 facing : class_2350.class_2353.field_11062) {
                    class_2338 offsetPosition = origin.method_10081(facing.method_10163().method_35862(i));
                    if (DimensionHooks.isSafeAround(level, offsetPosition)) {
                        return offsetPosition;
                    }
                    class_2338 heightmapPosition = level.method_8598(class_2902.class_2903.field_13197, offsetPosition);
                    if (!DimensionHooks.isSafeAround(level, heightmapPosition)) continue;
                    return heightmapPosition;
                }
            }
        }
        return origin;
    }

    public static boolean isSafeAround(class_1937 level, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        if (!DimensionHooks.isSafe(level, belowPos)) {
            return false;
        }
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            if (DimensionHooks.isSafe(level, belowPos.method_10079(facing, 2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(class_1937 level, class_2338 pos) {
        return level.method_8621().method_11952(pos) && level.method_8320(pos).method_26164(AetherTags.Blocks.AETHER_DIRT) && level.method_8320(pos.method_10084()).method_26215() && level.method_8320(pos.method_10086(2)).method_26215();
    }

    public static class_1269 createPortal(class_1657 player, class_1937 level, class_2338 pos, @Nullable class_2350 direction, class_1799 stack, class_1268 hand) {
        if (!FabricLoader.getInstance().isModLoaded("immersive_portals_core") && direction != null) {
            Optional<AetherPortalShape> optional;
            class_2338 relativePos = pos.method_10093(direction);
            if (stack.method_31573(AetherTags.Items.AETHER_PORTAL_ACTIVATION_ITEMS) && (level.method_27983() == LevelUtil.returnDimension() || level.method_27983() == LevelUtil.destinationDimension()) && (optional = AetherPortalShape.findEmptyAetherPortalShape((class_1936)level, relativePos, class_2350.class_2351.field_11048)).isPresent()) {
                optional.get().createPortalBlocks();
                player.method_5783(class_3417.field_14834, 1.0f, 1.0f);
                player.method_6104(hand);
                if (!player.method_7337()) {
                    if (stack.method_7947() > 1) {
                        stack.method_7934(1);
                        player.method_7270(stack.getRecipeRemainder());
                    } else if (stack.method_7963()) {
                        stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                    } else {
                        player.method_6122(hand, stack.getRecipeRemainder());
                    }
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static boolean detectWaterInFrame(class_1936 levelAccessor, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        if (!FabricLoader.getInstance().isModLoaded("immersive_portals_core") && levelAccessor instanceof class_1937) {
            Optional<AetherPortalShape> optional;
            class_1937 level = (class_1937)levelAccessor;
            if (fluidState.method_39360((class_3611)class_3612.field_15910) && fluidState.method_15759().method_26204() == blockState.method_26204() && (level.method_27983() == LevelUtil.returnDimension() || level.method_27983() == LevelUtil.destinationDimension()) && !((Boolean)AetherConfig.SERVER.disable_aether_portal.get()).booleanValue() && (optional = AetherPortalShape.findEmptyAetherPortalShape((class_1936)level, pos, class_2350.class_2351.field_11048)).isPresent()) {
                optional.get().createPortalBlocks();
                return true;
            }
        }
        return false;
    }

    public static void tickTime(class_1937 level) {
        if (level.method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177()) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            LevelAccessor levelAccessor = (LevelAccessor)level;
            long i = levelAccessor.aether$getLevelData().method_188() + 1L;
            serverLevelAccessor.aether$getServerLevelData().method_29034(i);
            if (serverLevelAccessor.aether$getServerLevelData().method_146().method_8355(class_1928.field_19396)) {
                serverLevel.method_29199(((AetherTimeAttachment)serverLevel.getAttachedOrCreate(AetherDataAttachments.AETHER_TIME)).tickTime(level));
            }
        }
    }

    public static void checkEternalDayConfig(class_1937 level) {
        if (!level.method_8608() && level.hasAttached(AetherDataAttachments.AETHER_TIME)) {
            AetherTimeAttachment aetherTime = (AetherTimeAttachment)level.getAttached(AetherDataAttachments.AETHER_TIME);
            boolean eternalDay = aetherTime.isEternalDay();
            if (((Boolean)AetherConfig.SERVER.disable_eternal_day.get()).booleanValue() && eternalDay) {
                aetherTime.setEternalDay(false);
                aetherTime.updateEternalDay(level);
            }
        }
    }

    public static void dimensionTravel(class_1297 entity, class_5321<class_1937> dimension) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_37908().method_8608()) {
            AetherPlayerAttachment aetherPlayer = (AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER);
            if (!(((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue() && aetherPlayer.canSpawnInAether() || !entity.method_37908().method_23753(entity.method_24515()).method_40220(AetherTags.Biomes.DISPLAY_TRAVEL_TEXT))) {
                if (entity.method_37908().method_27983() == LevelUtil.destinationDimension() && dimension == LevelUtil.returnDimension()) {
                    displayAetherTravel = true;
                    playerLeavingAether = true;
                    PacketDistributor.sendToAllPlayers(new AetherTravelPacket(true), new class_8710[0]);
                    PacketDistributor.sendToAllPlayers(new LeavingAetherPacket(true), new class_8710[0]);
                } else if (entity.method_37908().method_27983() == LevelUtil.returnDimension() && dimension == LevelUtil.destinationDimension()) {
                    displayAetherTravel = true;
                    playerLeavingAether = false;
                    PacketDistributor.sendToAllPlayers(new AetherTravelPacket(true), new class_8710[0]);
                    PacketDistributor.sendToAllPlayers(new LeavingAetherPacket(false), new class_8710[0]);
                } else {
                    displayAetherTravel = false;
                    PacketDistributor.sendToAllPlayers(new AetherTravelPacket(false), new class_8710[0]);
                }
            }
        }
    }

    public static void removePlayerAerbunny(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).removeAerbunny();
        }
    }

    public static void remountPlayerAerbunny(class_1657 player) {
        ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).remountAerbunny(player);
    }

    public static void travelling(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (teleportationTimer > 0) {
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.field_13987;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                --teleportationTimer;
            }
            if (teleportationTimer < 0 || serverPlayer.field_36331) {
                teleportationTimer = 0;
            }
        }
    }

    public static void initializeLevelData(class_1936 level) {
        class_3218 serverLevel;
        if (level instanceof class_3218 && (serverLevel = (class_3218)level).method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
            AetherLevelData levelData = new AetherLevelData(serverLevel, serverLevel.method_8503().method_27728(), serverLevel.method_8503().method_27728().method_27859(), ((AetherTimeAttachment)serverLevel.getAttachedOrCreate(AetherDataAttachments.AETHER_TIME)).getDayTime());
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            LevelAccessor levelAccessor = (LevelAccessor)level;
            serverLevelAccessor.aether$setServerLevelData((class_5268)levelData);
            levelAccessor.aether$setLevelData((class_5269)levelData);
        }
    }

    @Nullable
    public static Long finishSleep(class_1936 level, MutableLong newTime) {
        if (level instanceof class_3218 && level.method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
            serverLevelAccessor.aether$getServerLevelData().method_164(0);
            serverLevelAccessor.aether$getServerLevelData().method_157(false);
            serverLevelAccessor.aether$getServerLevelData().method_173(0);
            serverLevelAccessor.aether$getServerLevelData().method_147(false);
            long time = newTime.toLong() + 24000L * (long)AetherTimeAttachment.getTicksPerDayMultiplier();
            return time - time % (long)AetherTimeAttachment.getTicksPerDay();
        }
        return null;
    }

    public static boolean isEternalDay(class_1657 player) {
        if (player.method_37908().method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
            return ((AetherTimeAttachment)player.method_37908().getAttachedOrCreate(AetherDataAttachments.AETHER_TIME)).isEternalDay();
        }
        return false;
    }
}

