/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.attachment.LightningTrackerAttachment;
import com.aetherteam.aether.attachment.PhoenixArrowAttachment;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.entity.projectile.PoisonNeedle;
import com.aetherteam.aether.entity.projectile.dart.EnchantedDart;
import com.aetherteam.aether.entity.projectile.dart.GoldenDart;
import com.aetherteam.aether.entity.projectile.dart.PoisonDart;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.accessories.abilities.ZaniteAccessory;
import com.aetherteam.aether.item.tools.abilities.HolystoneTool;
import com.aetherteam.aether.item.tools.abilities.ZaniteTool;
import com.aetherteam.aether.loot.AetherLoot;
import com.aetherteam.aether.loot.AetherLootContexts;
import com.aetherteam.aether.network.packet.clientbound.ToolDebuffPacket;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AtomicDouble;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_9274;
import org.jetbrains.annotations.Nullable;

public class AbilityHooks {

    public static class WeaponHooks {
        public static void stickDart(class_1309 entity, class_1282 source) {
            class_1657 player;
            if (entity instanceof class_1657 && !(player = (class_1657)entity).method_37908().method_8608()) {
                class_1297 sourceEntity = source.method_5526();
                AetherPlayerAttachment data = (AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER);
                if (sourceEntity instanceof GoldenDart) {
                    data.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setGoldenDartCount", data.getGoldenDartCount() + 1);
                } else if (sourceEntity instanceof PoisonDart || sourceEntity instanceof PoisonNeedle) {
                    data.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setPoisonDartCount", data.getPoisonDartCount() + 1);
                } else if (sourceEntity instanceof EnchantedDart) {
                    data.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setEnchantedDartCount", data.getEnchantedDartCount() + 1);
                }
            }
        }

        public static void phoenixArrowHit(class_239 result, class_1676 projectile) {
            if (result instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)result;
                if (projectile instanceof class_1665) {
                    PhoenixArrowAttachment data;
                    class_1665 abstractArrow = (class_1665)projectile;
                    class_1297 impactedEntity = entityHitResult.method_17782();
                    if (impactedEntity.method_5864() == class_1299.field_6091) {
                        return;
                    }
                    if (abstractArrow.hasAttached(AetherDataAttachments.PHOENIX_ARROW) && (data = (PhoenixArrowAttachment)abstractArrow.getAttached(AetherDataAttachments.PHOENIX_ARROW)).isPhoenixArrow() && data.getFireTime() > 0) {
                        impactedEntity.method_5639((float)data.getFireTime());
                    }
                }
            }
        }

        public static boolean lightningTracking(class_1297 entity, class_1538 lightning) {
            if (entity instanceof class_1309) {
                LightningTrackerAttachment tracker;
                class_1297 owner;
                class_1309 livingEntity = (class_1309)entity;
                if (lightning.hasAttached(AetherDataAttachments.LIGHTNING_TRACKER) && (owner = (tracker = (LightningTrackerAttachment)lightning.getAttached(AetherDataAttachments.LIGHTNING_TRACKER)).getOwner(lightning.method_37908())) != null) {
                    return livingEntity == owner || livingEntity == owner.method_5854() || owner.method_5685().contains(livingEntity);
                }
            }
            return false;
        }

        public static float reduceWeaponEffectiveness(class_1309 target, class_1297 source, float damage) {
            if (((Boolean)AetherConfig.SERVER.tools_debuff.get()).booleanValue() && !target.method_37908().method_8608()) {
                class_1665 abstractArrow;
                double pow = Math.max(Math.pow(damage, (double)damage > 1.0 ? 0.6 : 1.6), 1.0);
                if (source instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)source;
                    class_1799 stack = livingEntity.method_6047();
                    if ((target.method_5864().method_5882().startsWith("entity.aether") || target.method_5864().method_20210(AetherTags.Entities.TREATED_AS_AETHER_ENTITY)) && !target.method_5864().method_20210(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY) && !stack.method_7960()) {
                        AtomicDouble value = new AtomicDouble();
                        stack.method_60617(class_9274.field_49217, (attribute, modifier) -> {
                            if (attribute.method_55838(class_5134.field_23721)) {
                                value.set(value.get() + modifier.comp_2449());
                            }
                        });
                        if (value.get() > livingEntity.method_45326(class_5134.field_23721) && !stack.method_7909().method_7876().startsWith("item.aether.") && !stack.method_31573(AetherTags.Items.TREATED_AS_AETHER_ITEM)) {
                            damage = (float)pow;
                        }
                    }
                } else if (!(!(source instanceof class_1676) || !target.method_5864().method_5882().startsWith("entity.aether") && !target.method_5864().method_20210(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) || target.method_5864().method_20210(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY) || source.method_5864().method_5882().startsWith("entity.aether") || source.method_5864().method_20210(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) || source instanceof class_1665 && (abstractArrow = (class_1665)source).hasAttached(AetherDataAttachments.PHOENIX_ARROW) && ((PhoenixArrowAttachment)abstractArrow.getAttached(AetherDataAttachments.PHOENIX_ARROW)).isPhoenixArrow())) {
                    damage = (float)pow;
                }
            }
            return damage;
        }

        public static float reduceArmorEffectiveness(class_1309 target, @Nullable class_1297 source, float damage) {
            if (source != null && (source.method_5864().method_5882().startsWith("entity.aether") || source.method_5864().method_20210(AetherTags.Entities.TREATED_AS_AETHER_ENTITY) && !source.method_5864().method_20210(AetherTags.Entities.TREATED_AS_VANILLA_ENTITY))) {
                for (class_1799 stack : target.method_5661()) {
                    class_1792 class_17922 = stack.method_7909();
                    if (!(class_17922 instanceof class_1738)) continue;
                    class_1738 armorItem = (class_1738)class_17922;
                    if (stack.method_7909().method_7876().startsWith("item.aether.") || stack.method_31573(AetherTags.Items.TREATED_AS_AETHER_ITEM)) continue;
                    AtomicDouble value = new AtomicDouble();
                    stack.method_57354(armorItem.method_7685(), (attribute, modifier) -> {
                        if (attribute.method_55838(class_5134.field_23724)) {
                            value.set(value.get() + modifier.comp_2449() / 15.0);
                        }
                    });
                    damage += (float)value.get();
                }
            }
            return damage;
        }
    }

    public static class ToolHooks {
        public static final Map<class_2248, class_2248> STRIPPABLES = new ImmutableMap.Builder().put((Object)((class_2248)AetherBlocks.SKYROOT_LOG.get()), (Object)((class_2248)AetherBlocks.STRIPPED_SKYROOT_LOG.get())).put((Object)((class_2248)AetherBlocks.GOLDEN_OAK_LOG.get()), (Object)((class_2248)AetherBlocks.STRIPPED_SKYROOT_LOG.get())).put((Object)((class_2248)AetherBlocks.SKYROOT_WOOD.get()), (Object)((class_2248)AetherBlocks.STRIPPED_SKYROOT_WOOD.get())).put((Object)((class_2248)AetherBlocks.GOLDEN_OAK_WOOD.get()), (Object)((class_2248)AetherBlocks.STRIPPED_SKYROOT_WOOD.get())).build();
        public static final Map<class_2248, class_2248> FLATTENABLES = new ImmutableMap.Builder().put((Object)((class_2248)AetherBlocks.AETHER_GRASS_BLOCK.get()), (Object)((class_2248)AetherBlocks.AETHER_DIRT_PATH.get())).put((Object)((class_2248)AetherBlocks.ENCHANTED_AETHER_GRASS_BLOCK.get()), (Object)((class_2248)AetherBlocks.AETHER_DIRT_PATH.get())).put((Object)((class_2248)AetherBlocks.AETHER_DIRT.get()), (Object)((class_2248)AetherBlocks.AETHER_DIRT_PATH.get())).build();
        public static final Map<class_2248, class_2248> TILLABLES = new ImmutableMap.Builder().put((Object)((class_2248)AetherBlocks.AETHER_DIRT.get()), (Object)((class_2248)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((class_2248)AetherBlocks.AETHER_GRASS_BLOCK.get()), (Object)((class_2248)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((class_2248)AetherBlocks.ENCHANTED_AETHER_GRASS_BLOCK.get()), (Object)((class_2248)AetherBlocks.AETHER_FARMLAND.get())).put((Object)((class_2248)AetherBlocks.AETHER_DIRT_PATH.get()), (Object)((class_2248)AetherBlocks.AETHER_FARMLAND.get())).build();
        public static boolean debuffTools;

        public static void handleHolystoneToolAbility(class_1657 player, class_1937 level, class_2338 pos, class_1799 stack, class_2680 blockState) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof HolystoneTool) {
                HolystoneTool holystoneTool = (HolystoneTool)class_17922;
                holystoneTool.dropAmbrosium(player, level, pos, stack, blockState);
            }
        }

        public static float handleZaniteToolAbility(class_1799 stack, float speed) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof ZaniteTool) {
                ZaniteTool zaniteTool = (ZaniteTool)class_17922;
                return zaniteTool.increaseSpeed(stack, speed);
            }
            return speed;
        }

        public static float reduceToolEffectiveness(class_1657 player, class_2680 state, class_1799 stack, float speed) {
            if (debuffTools && (state.method_26204().method_9539().startsWith("block.aether.") || state.method_26164(AetherTags.Blocks.TREATED_AS_AETHER_BLOCK)) && !state.method_26164(AetherTags.Blocks.TREATED_AS_VANILLA_BLOCK) && !stack.method_7960() && stack.method_7951(state) && !stack.method_7909().method_7876().startsWith("item.aether.") && !stack.method_31573(AetherTags.Items.TREATED_AS_AETHER_ITEM)) {
                speed = (float)Math.max(Math.pow(speed, (double)speed > 1.0 ? -0.5 : 1.5), 1.0);
            }
            return speed;
        }

        public static void setDebuffToolsState(class_3222 player) {
            if (debuffTools) {
                PacketDistributor.sendToPlayer(player, new ToolDebuffPacket(true), new class_8710[0]);
            } else if (((Boolean)AetherConfig.SERVER.tools_debuff.get()).booleanValue()) {
                debuffTools = true;
                PacketDistributor.sendToAllPlayers(new ToolDebuffPacket(true), new class_8710[0]);
            }
        }

        public static void resetDebuffToolsState() {
            debuffTools = false;
        }

        public static void stripGoldenOak(class_1936 accessor, class_2680 state, class_1799 stack, class_1838 context) {
            if (accessor instanceof class_1937) {
                class_1937 level = (class_1937)accessor;
                if (state.method_26164(AetherTags.Blocks.GOLDEN_OAK_LOGS) && stack.method_31573(AetherTags.Items.GOLDEN_AMBER_HARVESTERS) && level.method_8503() != null && level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_243 vector = context.method_17698();
                    class_8567 parameters = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1229, (Object)stack).method_51875(AetherLootContexts.STRIPPING);
                    class_52 lootTable = level.method_8503().method_58576().method_58295(AetherLoot.STRIP_GOLDEN_OAK);
                    ObjectArrayList list = lootTable.method_51878(parameters);
                    for (class_1799 itemStack : list) {
                        class_1542 itemEntity = new class_1542(level, vector.method_10216(), vector.method_10214(), vector.method_10215(), itemStack);
                        itemEntity.method_6988();
                        level.method_8649((class_1297)itemEntity);
                    }
                }
            }
        }
    }

    public static class ArmorHooks {
        public static boolean fallCancellation(class_1309 entity) {
            return EquipmentUtil.hasSentryBoots(entity) || EquipmentUtil.hasFullGravititeSet(entity) || EquipmentUtil.hasFullValkyrieSet(entity);
        }
    }

    public static class AccessoryHooks {
        public static void damageGloves(class_1657 player) {
            class_1937 class_19372;
            SlotEntryReference slotResult = EquipmentUtil.getGloves((class_1309)player);
            if (slotResult != null && (class_19372 = player.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                slotResult.stack().method_7956(1, serverLevel, (class_3222)player, item -> AccessoriesAPI.breakStack((SlotReference)slotResult.reference()));
            }
        }

        public static void damageZaniteRing(class_1309 entity, class_1936 level, class_2680 state, class_2338 pos) {
            List<SlotEntryReference> slotResults = EquipmentUtil.getZaniteRings(entity);
            for (SlotEntryReference slotResult : slotResults) {
                class_3222 serverPlayer;
                class_1937 class_19372;
                if (slotResult == null || !(state.method_26214((class_1922)level, pos) > 0.0f) || entity.method_59922().method_43048(6) != 0 || !((class_19372 = entity.method_37908()) instanceof class_3218)) continue;
                class_3218 serverLevel = (class_3218)class_19372;
                class_3222 player = entity instanceof class_3222 ? (serverPlayer = (class_3222)entity) : null;
                slotResult.stack().method_7956(1, serverLevel, player, item -> AccessoriesAPI.breakStack((SlotReference)slotResult.reference()));
            }
        }

        public static void damageZanitePendant(class_1309 entity, class_1936 level, class_2680 state, class_2338 pos) {
            class_1937 class_19372;
            SlotEntryReference slotResult = EquipmentUtil.getZanitePendant(entity);
            if (slotResult != null && state.method_26214((class_1922)level, pos) > 0.0f && entity.method_59922().method_43048(6) == 0 && (class_19372 = entity.method_37908()) instanceof class_3218) {
                class_3222 serverPlayer;
                class_3218 serverLevel = (class_3218)class_19372;
                class_3222 player = entity instanceof class_3222 ? (serverPlayer = (class_3222)entity) : null;
                slotResult.stack().method_7956(1, serverLevel, player, item -> AccessoriesAPI.breakStack((SlotReference)slotResult.reference()));
            }
        }

        public static float handleZaniteRingAbility(class_1309 entity, float speed) {
            float newSpeed = speed;
            List<SlotEntryReference> slotResults = EquipmentUtil.getZaniteRings(entity);
            for (SlotEntryReference slotResult : slotResults) {
                if (slotResult == null) continue;
                newSpeed = ZaniteAccessory.handleMiningSpeed(newSpeed, slotResult.stack());
            }
            return newSpeed;
        }

        public static float handleZanitePendantAbility(class_1309 entity, float speed) {
            SlotEntryReference slotResult = EquipmentUtil.getZanitePendant(entity);
            if (slotResult != null) {
                speed = ZaniteAccessory.handleMiningSpeed(speed, slotResult.stack());
            }
            return speed;
        }

        public static boolean preventTargeting(class_1309 target, @Nullable class_1297 lookingEntity) {
            if (target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                AetherPlayerAttachment data = (AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER);
                return lookingEntity != null && !lookingEntity.method_5864().method_20210(AetherTags.Entities.IGNORE_INVISIBILITY) && data.isWearingInvisibilityCloak() && data.isInvisibilityEnabled() && !data.attackedWithInvisibility();
            }
            return lookingEntity != null && !lookingEntity.method_5864().method_20210(AetherTags.Entities.IGNORE_INVISIBILITY) && EquipmentUtil.hasInvisibilityCloak(target);
        }

        public static boolean recentlyAttackedWithInvisibility(class_1309 target, class_1297 lookingEntity) {
            if (target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                AetherPlayerAttachment data = (AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER);
                return !lookingEntity.method_5864().method_20210(AetherTags.Entities.IGNORE_INVISIBILITY) && data.isWearingInvisibilityCloak() && data.isInvisibilityEnabled() && data.attackedWithInvisibility();
            }
            return false;
        }

        public static void setAttack(class_1282 source) {
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).setAttackedWithInvisibility(true);
            }
        }

        public static boolean preventMagmaDamage(class_1309 entity, class_1282 source) {
            return source == entity.method_37908().method_48963().method_48820() && EquipmentUtil.hasFreezingAccessory(entity);
        }
    }
}

