/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.NotGrounded;
import com.aetherteam.aether.entity.ai.goal.MostDamageTargetGoal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.ValkyrieTeleportEvent;
import java.util.EnumSet;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public abstract class AbstractValkyrie
extends class_1588
implements NotGrounded {
    private static final class_2940<Boolean> DATA_ENTITY_ON_GROUND_ID = class_2945.method_12791(AbstractValkyrie.class, (class_2941)class_2943.field_13323);
    private MostDamageTargetGoal mostDamageTargetGoal;
    private int lungeCooldown = 0;
    protected double lastMotionY;

    public AbstractValkyrie(class_1299<? extends AbstractValkyrie> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new ValkyrieMoveControl((class_1308)this);
    }

    public void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new ValkyrieTeleportGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 0.65, true));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f, 8.0f));
        this.mostDamageTargetGoal = new MostDamageTargetGoal((class_1308)this);
        this.field_6185.method_6277(1, (class_1352)this.mostDamageTargetGoal);
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.5);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_ENTITY_ON_GROUND_ID, (Object)true);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_24828()) {
            this.setEntityOnGround(true);
        }
        if (!this.method_37908().method_8608() && this.lungeCooldown > 0) {
            --this.lungeCooldown;
        }
    }

    public void method_6091(class_243 motion) {
        this.lastMotionY = this.method_18798().method_10214();
        super.method_6091(motion);
    }

    public void method_6043() {
        super.method_6043();
        this.setEntityOnGround(false);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        boolean result = super.method_5643(source, amount);
        if (!this.method_37908().method_8608() && result && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            this.mostDamageTargetGoal.addAggro(living, amount);
        }
        return result;
    }

    protected boolean teleportAroundTarget(class_1297 target) {
        class_241 targetVec = new class_241(this.method_59922().method_43057() - 0.5f, this.method_59922().method_43057() - 0.5f).method_35581();
        double x = target.method_23317() + (double)(targetVec.field_1343 * 3.0f);
        double y = target.method_23318();
        double z = target.method_23321() + (double)(targetVec.field_1342 * 3.0f);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        for (int i = 0; mutableBlockPos.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutableBlockPos).method_51366() && i <= 4; ++i) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
        boolean isValidSpot = blockState.method_26164(AetherTags.Blocks.VALKYRIE_TELEPORTABLE_ON);
        return isValidSpot && this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        ValkyrieTeleportEvent event = AetherEventDispatch.onValkyrieTeleport((class_1309)this, x, y, z);
        if (event.isCanceled()) {
            return false;
        }
        boolean flag = this.method_6082(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag) {
            this.spawnExplosionParticles();
        }
        return flag;
    }

    public void spawnExplosionParticles() {
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)70);
        }
    }

    protected void chat(class_1657 player, class_2561 message, boolean sound) {
        player.method_43496(message);
    }

    @Override
    public boolean isEntityOnGround() {
        return (Boolean)this.method_5841().method_12789(DATA_ENTITY_ON_GROUND_ID);
    }

    @Override
    public void setEntityOnGround(boolean onGround) {
        this.method_5841().method_12778(DATA_ENTITY_ON_GROUND_ID, (Object)onGround);
    }

    protected float method_49484() {
        return this.method_6029() * 0.216f;
    }

    protected boolean method_5860(class_1297 vehicle) {
        return false;
    }

    protected boolean method_23734() {
        return false;
    }

    public void method_5711(byte id) {
        if (id == 70) {
            for (int i = 0; i < 5; ++i) {
                EntityUtil.spawnMovementExplosionParticles((class_1297)this);
            }
        } else {
            super.method_5711(id);
        }
    }

    public static class ValkyrieMoveControl
    extends class_1335 {
        public ValkyrieMoveControl(class_1308 pMob) {
            super(pMob);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6379) {
                this.field_6374 = class_1335.class_1336.field_6378;
            }
            super.method_6240();
        }
    }

    public static class ValkyrieTeleportGoal
    extends class_1352 {
        private final AbstractValkyrie valkyrie;
        protected int teleportTimer;

        public ValkyrieTeleportGoal(AbstractValkyrie valkyrie) {
            this.valkyrie = valkyrie;
            this.teleportTimer = this.valkyrie.method_59922().method_43048(200);
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            if (this.teleportTimer++ < 450) {
                return;
            }
            this.teleportTimer = this.valkyrie.method_5968() != null && this.valkyrie.teleportAroundTarget((class_1297)this.valkyrie.method_5968()) ? this.valkyrie.method_59922().method_43048(40) : (this.teleportTimer -= 20);
        }

        public boolean method_38846() {
            return true;
        }
    }

    public static class LungeGoal
    extends class_1352 {
        private final AbstractValkyrie valkyrie;
        private final double speedModifier;
        private final int lungeCooldownMax;
        private int flyingTicks;

        public LungeGoal(AbstractValkyrie valkyrie, double speedModifier, int lungeCooldownMax) {
            this.valkyrie = valkyrie;
            this.speedModifier = speedModifier;
            this.lungeCooldownMax = lungeCooldownMax;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !this.valkyrie.method_24828() && this.valkyrie.lungeCooldown <= 0;
        }

        public void method_6268() {
            class_1309 target = this.valkyrie.method_5968();
            double motionY = this.valkyrie.method_18798().method_10214();
            if (target != null) {
                if (motionY < 0.2 && this.valkyrie.lastMotionY >= 0.2 && this.valkyrie.method_5739((class_1297)target) <= 16.0f) {
                    double x = target.method_23317() - this.valkyrie.method_23317();
                    double z = target.method_23321() - this.valkyrie.method_23321();
                    double angle = Math.atan2(x, z);
                    this.valkyrie.method_18800(Math.sin(angle) * 0.3, motionY -= 0.1, Math.cos(angle) * 0.3);
                    this.valkyrie.method_36456((float)angle * 57.295776f);
                    this.flyingTicks = 8;
                }
                if (this.flyingTicks > 0) {
                    --this.flyingTicks;
                    class_1324 gravity = this.valkyrie.method_5996(class_5134.field_49078);
                    double fallSpeed = gravity != null ? Math.max(gravity.method_6194() * -0.625, -0.275) : -0.275;
                    if (motionY < fallSpeed) {
                        this.valkyrie.method_18800(this.valkyrie.method_18798().method_10216(), fallSpeed, this.valkyrie.method_18798().method_10215());
                        this.valkyrie.setEntityOnGround(false);
                    }
                }
                class_243 position = target.method_19538();
                this.valkyrie.method_5962().method_6239(position.method_10216(), position.method_10214(), position.method_10215(), this.speedModifier);
            }
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            this.valkyrie.lungeCooldown = this.lungeCooldownMax;
        }
    }
}

