/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.miscellaneous;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.projectile.crystal.CloudCrystal;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1307;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class CloudMinion
extends class_1307 {
    private static final class_2940<Integer> DATA_OWNER_ID = class_2945.method_12791(CloudMinion.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_RIGHT_ID = class_2945.method_12791(CloudMinion.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_LIFESPAN_ID = class_2945.method_12791(CloudMinion.class, (class_2941)class_2943.field_13327);
    private boolean shouldShoot;
    private double targetX;
    private double targetY;
    private double targetZ;

    public CloudMinion(class_1299<? extends class_1307> type, class_1937 level) {
        super(type, level);
    }

    public CloudMinion(class_1937 level, class_1657 player, class_1306 armSide) {
        super(AetherEntityTypes.CLOUD_MINION.get(), level);
        this.setOwner(player);
        this.setSide(armSide);
        this.setLifeSpan(3600);
        this.field_5960 = true;
        this.setPositionFromOwner();
        this.method_5814(this.targetX, this.targetY, this.targetZ);
        this.method_36457(player.method_36455());
        this.method_36456(player.method_36454());
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1307.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23719, 10.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_OWNER_ID, (Object)0);
        builder.method_56912(DATA_IS_RIGHT_ID, (Object)true);
        builder.method_56912(DATA_LIFESPAN_ID, (Object)0);
    }

    public void method_5773() {
        super.method_5773();
        this.setLifeSpan(this.getLifeSpan() - 1);
        if (this.getLifeSpan() <= 0) {
            this.spawnExplosionParticles();
            this.method_5650(class_1297.class_5529.field_26999);
        } else if (this.getOwner() != null) {
            if (this.getOwner().method_5805()) {
                this.setPositionFromOwner();
                this.setRotationFromOwner();
                if (this.atShoulder()) {
                    class_243 motion = this.method_18798();
                    this.method_18799(motion.method_18805(0.65, 0.65, 0.65));
                    if (this.shouldShoot()) {
                        float offset = this.getSide() == class_1306.field_6183 ? 2.0f : -2.0f;
                        float rotation = class_3532.method_15393((float)(this.method_36454() + offset));
                        CloudCrystal crystal = new CloudCrystal(this.method_37908());
                        crystal.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                        crystal.method_24919((class_1297)this, this.method_36455(), rotation, 0.0f, 1.0f, 1.0f);
                        crystal.method_7432((class_1297)this.getOwner());
                        if (!this.method_37908().method_8608()) {
                            this.method_37908().method_8649((class_1297)crystal);
                        }
                        this.method_5783(AetherSoundEvents.ENTITY_CLOUD_MINION_SHOOT.get(), 0.75f, (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.2f + 1.0f);
                        this.setShouldShoot(false);
                    }
                } else {
                    this.approachOwner();
                }
            } else {
                this.spawnExplosionParticles();
                this.method_5650(class_1297.class_5529.field_26998);
            }
        } else {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void setPositionFromOwner() {
        if (this.getOwner() != null) {
            if (this.method_5739((class_1297)this.getOwner()) > 2.0f) {
                this.targetX = this.getOwner().method_23317();
                this.targetY = this.getOwner().method_23318() + 1.0;
                this.targetZ = this.getOwner().method_23321();
            } else {
                double yaw = this.getOwner().method_36454();
                yaw = this.getSide() == class_1306.field_6183 ? (yaw -= 90.0) : (yaw += 90.0);
                this.targetX = this.getOwner().method_23317() + Math.sin(yaw /= -57.2957763671875) * 1.05;
                this.targetY = this.getOwner().method_23318() + 1.0;
                this.targetZ = this.getOwner().method_23321() + Math.cos(yaw) * 1.05;
            }
        }
    }

    public void setRotationFromOwner() {
        if (this.getOwner() != null) {
            this.method_36456(this.getOwner().method_36454() + (this.getSide() == class_1306.field_6183 ? 1.0f : -1.0f));
            this.method_36457(this.getOwner().method_36455());
            this.method_5847(this.getOwner().method_5791());
        }
    }

    public boolean atShoulder() {
        double z;
        double y;
        double x = this.method_23317() - this.targetX;
        return Math.sqrt(x * x + (y = this.method_23318() - this.targetY) * y + (z = this.method_23321() - this.targetZ) * z) < 0.4;
    }

    public void approachOwner() {
        double x = this.targetX - this.method_23317();
        double y = this.targetY - this.method_23318();
        double z = this.targetZ - this.method_23321();
        double sqrt = Math.min(Math.sqrt(x * x + y * y + z * z), 1.5);
        class_243 motion = this.method_18798();
        double motionX = (motion.method_10216() + x / (sqrt * 3.25)) * sqrt / 2.0;
        double motionY = (motion.method_10214() + y / (sqrt * 3.25)) * sqrt / 2.0;
        double motionZ = (motion.method_10215() + z / (sqrt * 3.25)) * sqrt / 2.0;
        this.method_18800(motionX, motionY, motionZ);
    }

    public void spawnExplosionParticles() {
        if (this.method_37908().method_8608()) {
            EntityUtil.spawnSummoningExplosionParticles((class_1297)this);
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)70);
        }
    }

    protected void method_6070() {
    }

    protected boolean method_5860(class_1297 vehicle) {
        return false;
    }

    public boolean method_5643(class_1282 source, float damage) {
        return false;
    }

    @Nullable
    public class_1657 getOwner() {
        return (class_1657)this.method_37908().method_8469(((Integer)this.method_5841().method_12789(DATA_OWNER_ID)).intValue());
    }

    public void setOwner(class_1657 entity) {
        this.method_5841().method_12778(DATA_OWNER_ID, (Object)entity.method_5628());
    }

    public class_1306 getSide() {
        return (Boolean)this.method_5841().method_12789(DATA_IS_RIGHT_ID) != false ? class_1306.field_6183 : class_1306.field_6182;
    }

    public void setSide(class_1306 armSide) {
        this.method_5841().method_12778(DATA_IS_RIGHT_ID, (Object)(armSide == class_1306.field_6183 ? 1 : 0));
    }

    public int getLifeSpan() {
        return (Integer)this.method_5841().method_12789(DATA_LIFESPAN_ID);
    }

    public void setLifeSpan(int lifespan) {
        this.method_5841().method_12778(DATA_LIFESPAN_ID, (Object)lifespan);
    }

    public boolean shouldShoot() {
        return this.shouldShoot;
    }

    public void setShouldShoot(boolean shouldShoot) {
        this.shouldShoot = shouldShoot;
    }

    public void method_5711(byte id) {
        if (id == 70) {
            EntityUtil.spawnSummoningExplosionParticles((class_1297)this);
        } else {
            super.method_5711(id);
        }
    }
}

