/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.command;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3324;
import net.minecraft.class_3330;
import net.minecraft.class_3337;
import net.minecraft.class_3340;

public class SunAltarWhitelistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_DISABLED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.remove.failed"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"aether").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sun_altar_whitelist").requires(commandSourceStack -> commandSourceStack.method_9259(4))).then(class_2170.method_9247((String)"on").executes(context -> SunAltarWhitelistCommand.enableWhitelist((class_2168)context.getSource())))).then(class_2170.method_9247((String)"off").executes(context -> SunAltarWhitelistCommand.disableWhitelist((class_2168)context.getSource())))).then(class_2170.method_9247((String)"list").executes(context -> SunAltarWhitelistCommand.showList((class_2168)context.getSource())))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> {
            class_3324 playerlist = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerlist.method_14571().stream().filter(serverPlayer -> !playerlist.method_14590().method_14653(serverPlayer.method_7334())).map(player -> player.method_7334().getName()), (SuggestionsBuilder)builder);
        }).executes(context -> SunAltarWhitelistCommand.addPlayers((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> class_2172.method_9253((String[])((class_2168)context.getSource()).method_9211().method_3760().method_14560(), (SuggestionsBuilder)builder)).executes(context -> SunAltarWhitelistCommand.removePlayers((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"targets")))))).then(class_2170.method_9247((String)"reload").executes(context -> SunAltarWhitelistCommand.reload((class_2168)context.getSource())))));
    }

    private static int reload(class_2168 source) {
        SunAltarWhitelist.INSTANCE.reload();
        source.method_9226(() -> class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.reloaded"), true);
        return 1;
    }

    private static int addPlayers(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        class_3337 sunAltarWhiteList = SunAltarWhitelist.INSTANCE.getSunAltarWhiteList();
        int i = 0;
        for (GameProfile gameProfile : players) {
            if (sunAltarWhiteList.method_14653(gameProfile)) continue;
            class_3340 entry = new class_3340(gameProfile);
            sunAltarWhiteList.method_14633((class_3330)entry);
            source.method_9226(() -> class_2561.method_43469((String)"commands.aether.sun_altar_whitelist.add.success", (Object[])new Object[]{class_2561.method_43470((String)gameProfile.getName())}), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return i;
    }

    private static int removePlayers(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        class_3337 sunAltarWhiteList = SunAltarWhitelist.INSTANCE.getSunAltarWhiteList();
        int i = 0;
        for (GameProfile gameProfile : players) {
            if (!sunAltarWhiteList.method_14653(gameProfile)) continue;
            class_3340 userwhitelistentry = new class_3340(gameProfile);
            sunAltarWhiteList.method_14638((class_3330)userwhitelistentry);
            source.method_9226(() -> class_2561.method_43469((String)"commands.aether.sun_altar_whitelist.remove.success", (Object[])new Object[]{class_2561.method_43470((String)gameProfile.getName())}), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        source.method_9211().method_3728(source);
        return i;
    }

    private static int enableWhitelist(class_2168 source) throws CommandSyntaxException {
        if (((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue()) {
            throw ERROR_ALREADY_ENABLED.create();
        }
        AetherConfig.SERVER.sun_altar_whitelist.set((Object)true);
        AetherConfig.SERVER.sun_altar_whitelist.save();
        source.method_9226(() -> class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.enabled"), true);
        return 1;
    }

    private static int disableWhitelist(class_2168 source) throws CommandSyntaxException {
        if (!((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue()) {
            throw ERROR_ALREADY_DISABLED.create();
        }
        AetherConfig.SERVER.sun_altar_whitelist.set((Object)false);
        AetherConfig.SERVER.sun_altar_whitelist.save();
        source.method_9226(() -> class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.disabled"), true);
        return 1;
    }

    private static int showList(class_2168 source) {
        String[] names = SunAltarWhitelist.INSTANCE.getSunAltarWhiteListNames();
        if (names.length == 0) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.aether.sun_altar_whitelist.none"), false);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.aether.sun_altar_whitelist.list", (Object[])new Object[]{names.length, String.join((CharSequence)", ", names)}), false);
        }
        return names.length;
    }
}

