/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.gui.component.inventory.AccessoryButton;
import com.aetherteam.aether.client.gui.screen.inventory.AetherAccessoriesScreen;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1259;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3545;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_7845;

public class GuiListener {
    public static void listen() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            GuiListener.onGuiInitialize(screen, Screens.getButtons((class_437)screen)::add);
            ScreenEvents.afterRender((class_437)screen).register((screen1, drawContext, mouseX, mouseY, tickDelta) -> GuiListener.onGuiDraw(screen1, drawContext));
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> GuiListener.onClientTick());
    }

    public static void onGuiInitialize(class_437 screen, Consumer<class_4264> consumer) {
        if (GuiHooks.isAccessoryButtonEnabled()) {
            class_3545<Integer, Integer> offsets = AetherAccessoriesScreen.getButtonOffset(screen);
            AccessoryButton inventoryAccessoryButton = GuiHooks.setupAccessoryButton(screen, offsets);
            if (inventoryAccessoryButton != null) {
                consumer.accept((class_4264)inventoryAccessoryButton);
            }
        } else {
            class_7845 layout = GuiHooks.setupPerksButtons(screen);
            if (layout != null) {
                layout.method_48206(abstractWidget -> {
                    if (abstractWidget instanceof class_4264) {
                        class_4264 abstractButton = (class_4264)abstractWidget;
                        consumer.accept(abstractButton);
                    }
                });
            }
        }
    }

    public static void onGuiDraw(class_437 screen, class_332 guiGraphics) {
        if (!FabricLoader.getInstance().isModLoaded("tipsmod")) {
            GuiHooks.drawTrivia(screen, guiGraphics);
        }
        GuiHooks.drawAetherTravelMessage(screen, guiGraphics);
    }

    public static void onClientTick() {
        GuiHooks.handlePatreonRefreshRebound();
        GuiHooks.openAccessoryMenu();
    }

    public static void onKeyPress(int key, int action) {
        GuiHooks.closeContainerMenu(key, action);
    }

    public static boolean onRenderBossBar(class_332 guiGraphics, int k, int j, class_1259 bossEvent) {
        UUID bossUUID = bossEvent.method_5407();
        if (bossEvent instanceof class_345) {
            class_345 lerpingBossEvent = (class_345)bossEvent;
            if (GuiHooks.isAetherBossBar(bossUUID)) {
                GuiHooks.drawBossHealthBar(guiGraphics, k, j, lerpingBossEvent);
                return true;
            }
        }
        return false;
    }
}

