/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.DimensionClientHooks;
import com.aetherteam.aetherfabric.client.events.FogAdjustmentHelper;
import com.aetherteam.aetherfabric.client.events.FogColorHelper;
import com.aetherteam.aetherfabric.client.events.FogEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_4184;
import net.minecraft.class_758;
import org.apache.commons.lang3.tuple.Triple;

public class DimensionClientListener {
    public static void listen() {
        FogEvents.ON_FOG_RENDER.register(DimensionClientListener::onRenderFog);
        FogEvents.ON_FOG_COLORING.register(DimensionClientListener::onRenderFogColor);
        ClientTickEvents.END_CLIENT_TICK.register(client -> DimensionClientListener.onClientTick());
    }

    public static void onRenderFog(FogAdjustmentHelper event) {
        class_4184 camera = event.getCamera();
        class_758.class_4596 fogMode = event.getMode();
        Float renderNearFog = DimensionClientHooks.renderNearFog(camera, fogMode, event.getFarPlaneDistance());
        if (!event.isCanceled() && renderNearFog != null) {
            event.setNearPlaneDistance(renderNearFog.floatValue());
            event.setCanceled(true);
        }
        Float reduceLavaFog = DimensionClientHooks.reduceLavaFog(camera, event.getNearPlaneDistance());
        if (!event.isCanceled() && reduceLavaFog != null) {
            event.setNearPlaneDistance(reduceLavaFog.floatValue());
            event.setFarPlaneDistance(reduceLavaFog.floatValue() * 4.0f);
            event.setCanceled(true);
        }
    }

    public static void onRenderFogColor(FogColorHelper event) {
        Triple<Float, Float, Float> adjustWeatherFogColors;
        class_4184 camera = event.getCamera();
        Triple<Float, Float, Float> renderFogColors = DimensionClientHooks.renderFogColors(camera, event.getRed(), event.getGreen(), event.getBlue());
        if (renderFogColors != null) {
            event.setRed(((Float)renderFogColors.getLeft()).floatValue());
            event.setGreen(((Float)renderFogColors.getMiddle()).floatValue());
            event.setBlue(((Float)renderFogColors.getRight()).floatValue());
        }
        if ((adjustWeatherFogColors = DimensionClientHooks.adjustWeatherFogColors(camera, event.getRed(), event.getGreen(), event.getBlue())) != null) {
            event.setRed(((Float)adjustWeatherFogColors.getLeft()).floatValue());
            event.setGreen(((Float)adjustWeatherFogColors.getMiddle()).floatValue());
            event.setBlue(((Float)adjustWeatherFogColors.getRight()).floatValue());
        }
    }

    public static void onClientTick() {
        DimensionClientHooks.tickTime();
    }
}

