/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.AetherTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class LevelClientHooks {
    private static final HashMap<Integer, List<class_2338>> positionsForTypes = new HashMap();

    public static void renderDungeonBlockOverlays(class_4587 poseStack, class_4184 camera, class_4604 frustum, class_310 minecraft) {
        if (minecraft.field_1687 != null) {
            class_746 player = minecraft.field_1724;
            class_638 level = minecraft.field_1687;
            class_4599 renderBuffers = minecraft.method_22940();
            int range = 32;
            if (player != null && player.method_7337()) {
                class_2338 playerPos = player.method_24515();
                class_1799 stack = player.method_6047();
                int type = LevelClientHooks.idForItem(stack);
                if (type != -1) {
                    LevelClientHooks.updatePositions(playerPos, level, stack, range, type, false);
                }
                for (int i = 0; i < positionsForTypes.size(); ++i) {
                    LevelClientHooks.renderOverlays(level, poseStack, renderBuffers, camera, frustum, i);
                    LevelClientHooks.updatePositions(playerPos, level, stack, range, i, true);
                }
            }
        }
    }

    private static void updatePositions(class_2338 playerPos, class_638 level, class_1799 stack, int range, int type, boolean depopulate) {
        positionsForTypes.putIfAbsent(0, new ArrayList());
        positionsForTypes.putIfAbsent(1, new ArrayList());
        positionsForTypes.putIfAbsent(2, new ArrayList());
        positionsForTypes.putIfAbsent(3, new ArrayList());
        for (int c = 0; c < 667; ++c) {
            class_2338 pos;
            int x = playerPos.method_10263() + level.method_8409().method_43048(range) - level.method_8409().method_43048(range);
            int y = playerPos.method_10264() + level.method_8409().method_43048(range) - level.method_8409().method_43048(range);
            int z = playerPos.method_10260() + level.method_8409().method_43048(range) - level.method_8409().method_43048(range);
            if (!depopulate) {
                class_2338 pos2 = new class_2338(x, y, z);
                if (!stack.method_31574(level.method_8320(pos2).method_26204().method_8389()) || positionsForTypes.get(type).contains(pos2)) continue;
                positionsForTypes.get(type).add(pos2);
                continue;
            }
            List<class_2338> positions = positionsForTypes.get(type);
            if (positions.isEmpty() || level.method_8409().method_43048(100) != 0 || stack.method_31574(level.method_8320(pos = positions.get(level.method_8409().method_43048(positions.size()))).method_26204().method_8389())) continue;
            positions.remove(pos);
            positionsForTypes.put(type, positions);
        }
    }

    private static void renderOverlays(class_638 level, class_4587 poseStack, class_4599 renderBuffers, class_4184 camera, class_4604 frustum, int type) {
        for (class_2338 blockPos : positionsForTypes.get(type)) {
            if (!frustum.method_23093(new class_238(blockPos)) || level.method_8320(blockPos).method_26217() == class_2464.field_11455) continue;
            LevelClientHooks.drawSurfaces((class_4597)renderBuffers.method_23000(), poseStack.method_23760(), blockPos, camera, (float)((double)blockPos.method_10263() - camera.method_19326().method_10216()) - 0.001f, (float)((double)blockPos.method_10260() - camera.method_19326().method_10215()) - 0.001f, (float)((double)blockPos.method_10263() - camera.method_19326().method_10216()) + 1.001f, (float)((double)blockPos.method_10260() - camera.method_19326().method_10215()) + 1.001f, (float)((double)blockPos.method_10264() - camera.method_19326().method_10214()) - 0.001f, (float)((double)blockPos.method_10264() - camera.method_19326().method_10214()) + 1.001f, type);
        }
        renderBuffers.method_23000().method_22993();
    }

    private static void drawSurfaces(class_4597 buffer, class_4587.class_4665 pose, class_2338 blockPos, class_4184 camera, float startX, float startZ, float endX, float endZ, float botY, float topY, int type) {
        class_4588 builder = buffer.getBuffer(class_1921.method_23581());
        class_1058 sprite = LevelClientHooks.spriteForId(type);
        if (sprite != null) {
            float minU = sprite.method_4577();
            float maxU = sprite.method_4594();
            float minV = sprite.method_4575();
            float maxV = sprite.method_4593();
            if (camera.method_19326().method_10214() < (double)((float)blockPos.method_10264() + botY)) {
                LevelClientHooks.buildVertex(builder, pose, startX, botY, startZ, minU, minV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, botY, startZ, maxU, minV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, botY, endZ, maxU, maxV, 0.0f, -1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, botY, endZ, minU, maxV, 0.0f, -1.0f, 0.0f);
            }
            if (camera.method_19326().method_10214() > (double)((float)blockPos.method_10264() + topY)) {
                LevelClientHooks.buildVertex(builder, pose, endX, topY, startZ, minU, minV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, startZ, maxU, minV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, endZ, maxU, maxV, 0.0f, 1.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, topY, endZ, minU, maxV, 0.0f, 1.0f, 0.0f);
            }
            if (camera.method_19326().method_10215() < (double)((float)blockPos.method_10260() + startZ)) {
                LevelClientHooks.buildVertex(builder, pose, startX, botY, startZ, minU, minV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, startZ, minU, maxV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, topY, startZ, maxU, maxV, 0.0f, 0.0f, -1.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, botY, startZ, maxU, minV, 0.0f, 0.0f, -1.0f);
            }
            if (camera.method_19326().method_10215() > (double)((float)blockPos.method_10260() + endZ)) {
                LevelClientHooks.buildVertex(builder, pose, endX, botY, endZ, minU, minV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, topY, endZ, minU, maxV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, endZ, maxU, maxV, 0.0f, 0.0f, 1.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, botY, endZ, maxU, minV, 0.0f, 0.0f, 1.0f);
            }
            if (camera.method_19326().method_10216() < (double)((float)blockPos.method_10263() + startX)) {
                LevelClientHooks.buildVertex(builder, pose, startX, botY, endZ, minU, minV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, endZ, minU, maxV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, topY, startZ, maxU, maxV, -1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, startX, botY, startZ, maxU, minV, -1.0f, 0.0f, 0.0f);
            }
            if (camera.method_19326().method_10216() > (double)((float)blockPos.method_10263() + endX)) {
                LevelClientHooks.buildVertex(builder, pose, endX, botY, startZ, minU, minV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, topY, startZ, minU, maxV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, topY, endZ, maxU, maxV, 1.0f, 0.0f, 0.0f);
                LevelClientHooks.buildVertex(builder, pose, endX, botY, endZ, maxU, minV, 1.0f, 0.0f, 0.0f);
            }
        }
    }

    private static void buildVertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
        builder.method_56824(pose, x, y, z).method_1336(255, 255, 255, 170).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(240).method_60831(pose, normalX, normalY, normalZ);
    }

    @Nullable
    private static class_1058 spriteForId(int id) {
        switch (id) {
            case 0: {
                return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"aether", (String)"block/dungeon/lock"));
            }
            case 1: {
                return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"aether", (String)"block/dungeon/exclamation"));
            }
            case 2: {
                return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"aether", (String)"block/dungeon/door"));
            }
            case 3: {
                return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655((String)"aether", (String)"block/dungeon/treasure"));
            }
        }
        return null;
    }

    private static int idForItem(class_1799 stack) {
        if (stack.method_31573(AetherTags.Items.LOCKED_DUNGEON_BLOCKS)) {
            return 0;
        }
        if (stack.method_31573(AetherTags.Items.TRAPPED_DUNGEON_BLOCKS)) {
            return 1;
        }
        if (stack.method_31573(AetherTags.Items.BOSS_DOORWAY_DUNGEON_BLOCKS)) {
            return 2;
        }
        if (stack.method_31573(AetherTags.Items.TREASURE_DOORWAY_DUNGEON_BLOCKS)) {
            return 3;
        }
        return -1;
    }
}

