/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.attachment;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.network.packet.AetherTimeSyncPacket;
import com.aetherteam.aether.world.AetherLevelData;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.aetherteam.nitrogen.network.packet.SyncPacket;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5217;
import org.apache.commons.lang3.tuple.Triple;

public class AetherTimeAttachment
implements INBTSynchable {
    private static int ticksPerDayMultiplier = -1;
    private long dayTime = -1L;
    private boolean isEternalDay = true;
    private boolean shouldWait = false;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setEternalDay", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setEternalDay((Boolean)object), this::isEternalDay)), Map.entry("setShouldWait", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldWait((Boolean)object), this::getShouldWait)));
    public static final Codec<AetherTimeAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("day_time").forGetter(AetherTimeAttachment::getDayTime), (App)Codec.BOOL.fieldOf("eternal_day").forGetter(AetherTimeAttachment::isEternalDay), (App)Codec.BOOL.fieldOf("should_wait").forGetter(AetherTimeAttachment::getShouldWait)).apply((Applicative)instance, AetherTimeAttachment::new));

    protected AetherTimeAttachment() {
    }

    private AetherTimeAttachment(long time, boolean eternalDay, boolean shouldWait) {
        this.setDayTime(time);
        this.setEternalDay(eternalDay);
        this.setShouldWait(shouldWait);
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public long tickTime(class_1937 level) {
        long dayTime = level.method_8532();
        if (this.getDayTime() == -1L) {
            dayTime = AetherTimeAttachment.getTicksPerDay() / 4;
        }
        if (!this.isTimeSynced()) {
            if (this.isEternalDay() || this.getShouldWait()) {
                class_5217 class_52172;
                if (dayTime != (long)(AetherTimeAttachment.getTicksPerDay() / 4)) {
                    long tempTime = dayTime % (long)AetherTimeAttachment.getTicksPerDay();
                    if ((double)tempTime > (double)AetherTimeAttachment.getTicksPerDay() * 0.75) {
                        tempTime -= (long)AetherTimeAttachment.getTicksPerDay();
                    }
                    long target = class_3532.method_53062((long)((long)(AetherTimeAttachment.getTicksPerDay() / 4) - tempTime), (long)-10L, (long)10L);
                    dayTime += target;
                }
                if (!level.method_8608() && (class_52172 = level.method_8401()) instanceof AetherLevelData) {
                    AetherLevelData aetherLevelData = (AetherLevelData)class_52172;
                    if (((Boolean)AetherConfig.SERVER.sync_aether_time.get()).booleanValue()) {
                        if (aetherLevelData.getOverworldDayTime() == aetherLevelData.method_217()) {
                            this.setSynched(-1, INBTSynchable.Direction.DIMENSION, "setShouldWait", false, level);
                        }
                    } else if (this.getShouldWait()) {
                        this.setSynched(-1, INBTSynchable.Direction.DIMENSION, "setShouldWait", false, level);
                    }
                }
            } else {
                ++dayTime;
            }
        }
        this.setDayTime(dayTime);
        return dayTime;
    }

    public void updateEternalDay(class_1937 level) {
        this.setSynched(-1, INBTSynchable.Direction.DIMENSION, "setEternalDay", this.isEternalDay, level);
    }

    public void updateEternalDay(class_3222 player) {
        this.setSynched(player.method_5628(), INBTSynchable.Direction.PLAYER, "setEternalDay", this.isEternalDay, player);
    }

    public void setDayTime(long time) {
        this.dayTime = time;
    }

    public long getDayTime() {
        return this.dayTime;
    }

    public void setEternalDay(boolean isEternalDay) {
        this.isEternalDay = isEternalDay;
    }

    public boolean isEternalDay() {
        return this.isEternalDay;
    }

    public void setShouldWait(boolean shouldWait) {
        this.shouldWait = shouldWait;
    }

    public boolean getShouldWait() {
        return this.shouldWait;
    }

    public boolean isTimeSynced() {
        return (Boolean)AetherConfig.SERVER.sync_aether_time.get() != false && !this.isEternalDay() && !this.getShouldWait();
    }

    public SyncPacket getSyncPacket(int entityID, String key, INBTSynchable.Type type, Object value) {
        return new AetherTimeSyncPacket(key, type, value);
    }

    public static int getTicksPerDayMultiplier() {
        if (ticksPerDayMultiplier < 0) {
            ticksPerDayMultiplier = (Boolean)AetherConfig.SERVER.normal_length_aether_time.get() != false || (Boolean)AetherConfig.SERVER.sync_aether_time.get() != false ? 1 : 3;
        }
        return ticksPerDayMultiplier;
    }

    public static int getTicksPerDay() {
        return 24000 * AetherTimeAttachment.getTicksPerDayMultiplier();
    }
}

